/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation.json;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.validation.json.ValidationAction;
import org.apache.jena.fuseki.validation.json.ValidatorJsonLib;
import org.apache.jena.iri3986.provider.IRIProvider3986;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIx;

public class IRIValidatorJSON {
    static final String paramIRI = "iri";
    static final String jIRIs = "iris";
    static final String jIRI = "iri";

    public static JsonObject execute(ValidationAction action) {
        JsonBuilder obj = new JsonBuilder();
        obj.startObject();
        String[] args = ValidatorJsonLib.getArgs(action, "iri");
        if (args == null || args.length == 0) {
            ServletOps.errorBadRequest("No IRIs supplied");
            return null;
        }
        obj.key(jIRIs);
        obj.startArray();
        IRIProvider3986 provider = new IRIProvider3986();
        for (String iriStr : args) {
            obj.startObject();
            obj.key("iri").value(iriStr);
            ArrayList<CallSite> errors = new ArrayList<CallSite>();
            ArrayList<CallSite> warnings = new ArrayList<CallSite>();
            try {
                IRIx iri2 = provider.create(iriStr);
                System.out.println(iriStr + " ==> " + String.valueOf(iri2));
                if (iri2.isRelative() && iri2.isRelative()) {
                    warnings.add((CallSite)((Object)("Relative IRI: " + iriStr)));
                }
                iri2.handleViolations((error, msg) -> {
                    if (error.booleanValue()) {
                        errors.add((CallSite)msg);
                    } else {
                        warnings.add((CallSite)msg);
                    }
                });
            }
            catch (IRIException ex) {
                errors.add((CallSite)((Object)("Bad IRI: " + ex.getMessage())));
            }
            obj.key("errors");
            obj.startArray();
            for (String string : errors) {
                obj.value(string);
            }
            obj.finishArray();
            obj.key("warning");
            obj.startArray();
            for (String string : warnings) {
                obj.value(string);
            }
            obj.finishArray();
            obj.finishObject();
        }
        obj.finishArray();
        obj.finishObject();
        return obj.build().getAsObject();
    }
}

