/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.irix;

import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.iri3986.provider.IRIProvider3986;
import org.apache.jena.iri3986.provider.InitIRI3986;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIProvider;
import org.apache.jena.irix.IRIProviderJDK;
import org.apache.jena.irix.IRIProviderJenaIRI;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.IRIx;
import org.apache.jena.shared.JenaException;

public class SystemIRIx {
    private static final ProviderImpl providerImpl = ProviderImpl.IRI0;
    private static IRIProvider provider = SystemIRIx.makeFreshSystemProvider();
    public static final String envVariableProvider = "JENA_IRIPROVIDER";
    public static final String sysPropertyProvider = "jena.iriprovider";
    private static final IRIx cwdURI;
    private static IRIx systemBase;
    private static String fallbackBaseURI;

    public static IRIProvider makeFreshSystemProvider() {
        ProviderImpl sysProviderImpl = SystemIRIx.getProviderImpl();
        return switch (sysProviderImpl) {
            case ProviderImpl.IRI3986 -> SystemIRIx.makeProviderIRI3986();
            case ProviderImpl.IRI0 -> SystemIRIx.makeProviderJenaIRI();
            default -> throw new JenaException("Unknown IRIx Provider");
        };
    }

    private static ProviderImpl getProviderImpl() {
        ProviderImpl sysProviderImpl = providerImpl;
        String p = Lib.getenv(sysPropertyProvider, envVariableProvider);
        if (p != null) {
            ProviderImpl impl;
            String pNorm;
            switch (pNorm = Lib.uppercase(p)) {
                case "IRI3986": {
                    ProviderImpl providerImpl = ProviderImpl.IRI3986;
                    break;
                }
                case "IRI0": {
                    ProviderImpl providerImpl = ProviderImpl.IRI0;
                    break;
                }
                default: {
                    ProviderImpl providerImpl = impl = null;
                }
            }
            if (impl == null) {
                Log.error(SystemIRIx.class, "IRI Provider not recognized: " + pNorm);
                return sysProviderImpl;
            }
            sysProviderImpl = impl;
        }
        return sysProviderImpl;
    }

    public static void init() {
    }

    public static void reset() {
        provider = SystemIRIx.makeFreshSystemProvider();
    }

    public static void setProvider(IRIProvider aProvider) {
        provider = aProvider;
        IRIx iri2 = SystemIRIx.setupBase(systemBase.str());
        SystemIRIx.setSystemBase(iri2);
    }

    public static IRIProvider getProvider() {
        return provider;
    }

    public static void strictMode(String scheme, boolean runStrict) {
        SystemIRIx.getProvider().strictMode(scheme, runStrict);
    }

    public static boolean isStrictMode(String scheme) {
        return SystemIRIx.getProvider().isStrictMode(scheme);
    }

    static IRIx getSystemBase() {
        return systemBase;
    }

    private static IRIx establishBaseURI() {
        SystemIRIx.init();
        try {
            Object baseStr = IRILib.filenameToIRI("./");
            if (!((String)baseStr).endsWith("/")) {
                baseStr = (String)baseStr + "/";
            }
            return SystemIRIx.setupBase((String)baseStr);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return IRIx.create(fallbackBaseURI);
        }
    }

    private static IRIx setupBase(String baseStr) {
        if (baseStr == null) {
            return IRIx.create(fallbackBaseURI);
        }
        try {
            IRIx base = IRIx.create(baseStr);
            if (!base.isReference()) {
                Log.error(IRIs.class, "System base URI is not a reference URI: must have scheme, host and path");
            }
            return base;
        }
        catch (IRIException ex) {
            Log.error(IRIs.class, "Failed to create IRI from '" + baseStr + "'", ex);
            return IRIx.create(fallbackBaseURI);
        }
    }

    private static void setSystemBase(IRIx iri2) {
        systemBase = iri2;
    }

    private static IRIProvider makeProviderJenaIRI() {
        IRIProviderJenaIRI newProviderJenaIRI = new IRIProviderJenaIRI();
        newProviderJenaIRI.strictMode("urn", false);
        newProviderJenaIRI.strictMode("http", false);
        newProviderJenaIRI.strictMode("file", false);
        return newProviderJenaIRI;
    }

    private static IRIProvider makeProviderIRI3986() {
        InitIRI3986.init();
        IRIProvider3986 providerIRI3986 = new IRIProvider3986();
        return providerIRI3986;
    }

    private static IRIProvider makeProviderJDK() {
        return new IRIProviderJDK();
    }

    static {
        systemBase = cwdURI = SystemIRIx.establishBaseURI();
        fallbackBaseURI = "urn:jena:base";
    }

    private static enum ProviderImpl {
        IRI0,
        IRI3986;

    }
}

