/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shex.expressions.ShapeExprVisitor;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.sys.ValidationContext;

public class ShapeExprAND
extends ShapeExpression {
    List<ShapeExpression> shapeExpressions;

    public static ShapeExpression create(List<ShapeExpression> acc) {
        if (acc.size() == 0) {
            throw new InternalErrorException("Empty list");
        }
        if (acc.size() == 1) {
            return acc.get(0);
        }
        return new ShapeExprAND(acc);
    }

    private ShapeExprAND(List<ShapeExpression> expressions) {
        this.shapeExpressions = expressions;
    }

    public List<ShapeExpression> expressions() {
        return this.shapeExpressions;
    }

    @Override
    public boolean satisfies(ValidationContext vCxt, Node data) {
        for (ShapeExpression shExpr : this.shapeExpressions) {
            boolean innerSatisfies = shExpr.satisfies(vCxt, data);
            if (innerSatisfies) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visit(ShapeExprVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void print(IndentedWriter out, NodeFormatter nFmt) {
        out.println("AND");
        int idx = 0;
        for (ShapeExpression shExpr : this.shapeExpressions) {
            out.printf("%d -", ++idx);
            out.incIndent(4);
            shExpr.print(out, nFmt);
            out.decIndent(4);
        }
        out.println("/AND");
    }

    @Override
    public String toString() {
        return "ShapeExprAnd " + String.valueOf(this.expressions());
    }

    @Override
    public int hashCode() {
        return Objects.hash(1, this.shapeExpressions);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShapeExprAND other = (ShapeExprAND)obj;
        return Objects.equals(this.shapeExpressions, other.shapeExpressions);
    }
}

