/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.codec.digest.MurmurHash3;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.atlas.lib.SetUtils;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.atlas.logging.Log;

public class Lib {
    private Lib() {
    }

    public static String concatPaths(String directory, String path) {
        Objects.requireNonNull(directory);
        Objects.requireNonNull(path);
        if (path.startsWith("/")) {
            return path;
        }
        if (path.isEmpty()) {
            return directory;
        }
        if (directory.endsWith("/")) {
            return directory + path;
        }
        return directory + "/" + path;
    }

    public static final <X> Set<X> concurrentHashSet() {
        return SetUtils.concurrentHashSet();
    }

    public static final void sync(Object object) {
        if (object instanceof Sync) {
            Sync syncobj = (Sync)object;
            syncobj.sync();
        }
    }

    public static final <T> boolean equals(T obj1, T obj2) {
        return Objects.equals(obj1, obj2);
    }

    public static final boolean equalsIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static final <T> boolean notEqual(T obj1, T obj2) {
        return !Objects.equals(obj1, obj2);
    }

    public static final String className(Object obj) {
        if (obj == null) {
            return "null";
        }
        return Lib.classShortName(obj.getClass());
    }

    public static final String classShortName(Class<?> cls) {
        if (cls == null) {
            return "null";
        }
        return cls.getSimpleName();
    }

    public static UnsupportedOperationException unsupportedMethod(Object object, String method) {
        return new UnsupportedOperationException(Lib.className(object) + "." + method);
    }

    public static RuntimeException runtimeException(Exception ex) {
        if (ex instanceof RuntimeException) {
            RuntimeException ex2 = (RuntimeException)ex;
            throw ex2;
        }
        return new RuntimeException(ex.getMessage(), ex);
    }

    public static <T> boolean equalsListAsSet(List<T> list1, List<T> list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null) {
            return false;
        }
        if (list2 == null) {
            return false;
        }
        return list1.containsAll(list2) && list2.containsAll(list1);
    }

    public static final int hashCodeObject(Object obj) {
        return Lib.hashCodeObject(obj, -4);
    }

    public static final int hashCodeObject(Object obj, int nullHashCode) {
        if (obj == null) {
            return nullHashCode;
        }
        return obj.hashCode();
    }

    public static boolean isEmpty(CharSequence cs) {
        return StringUtils.isEmpty(cs);
    }

    public static String lowercase(String string) {
        return string.toLowerCase(Locale.ROOT);
    }

    public static String uppercase(String string) {
        return string.toUpperCase(Locale.ROOT);
    }

    public static final void sleep(int milliSeconds) {
        try {
            Thread.sleep(milliSeconds);
        }
        catch (InterruptedException ex) {
            Log.warn(Lib.class, "interrupted", ex);
        }
    }

    public static String getenv(String name) {
        return Lib.getenv(name, name);
    }

    public static String getenv(String sysPropName, String envName) {
        String x = System.getProperty(sysPropName);
        if (x == null) {
            x = System.getenv(envName);
        }
        return x;
    }

    public static void setenv(String sysPropName, String value) {
        System.getProperties().setProperty(sysPropName, value);
    }

    public static void unsetenv(String sysPropName) {
        System.getProperties().remove(sysPropName);
    }

    public static boolean isPropertyOrEnvVarSetToTrue(String name) {
        return Lib.isPropertyOrEnvVarSetToTrue(name, name);
    }

    public static boolean isPropertyOrEnvVarSetToTrue(String sysPropName, String envName) {
        String value = Lib.getenv(sysPropName, envName);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }

    public static <X> X readThreadLocal(ThreadLocal<X> threadLocal) {
        X x = threadLocal.get();
        if (x == null) {
            threadLocal.remove();
        }
        return x;
    }

    public static long crc32(byte[] bytes) {
        return Lib.crc(new CRC32(), bytes);
    }

    public static long adler32(byte[] bytes) {
        return Lib.crc(new Adler32(), bytes);
    }

    private static long crc(Checksum alg, byte[] bytes) {
        alg.reset();
        alg.update(bytes, 0, bytes.length);
        return alg.getValue();
    }

    public static String murmurHashHex(String string) {
        byte[] input = string.getBytes(StandardCharsets.UTF_8);
        long[] x = MurmurHash3.hash128x64(input);
        char[] chars = new char[32];
        Lib.longAsHexLC(x[0], chars, 0);
        Lib.longAsHexLC(x[1], chars, 16);
        return new String(chars);
    }

    private static void longAsHexLC(long value, char[] chars, int start) {
        for (int idx = 0; idx < 8; ++idx) {
            int i = idx * 8;
            int bValue = (int)(value >> i & 0xFFL);
            int hi = (bValue & 0xF0) >> 4;
            int lo = bValue & 0xF;
            char chHi = Chars.hexDigitsLC[hi];
            char chLo = Chars.hexDigitsLC[lo];
            chars[start + 2 * idx] = chHi;
            chars[start + 2 * idx + 1] = chLo;
        }
    }

    public static <X> Set<Set<X>> powerSet(Set<X> elts) {
        ArrayList<X> list = new ArrayList<X>(elts);
        int size = list.size();
        long N = (long)Math.pow(2.0, list.size());
        HashSet<Set<X>> output = new HashSet<Set<X>>();
        int i = 0;
        while ((long)i < N) {
            HashSet elt = new HashSet();
            for (int j = 0; j < size; ++j) {
                int x = 1 << j;
                if ((x & i) == 0) continue;
                elt.add(list.get(j));
            }
            output.add(elt);
            ++i;
        }
        return output;
    }
}

