/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3.ui;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BeanSession;
import org.apache.juneau.MediaType;
import org.apache.juneau.bean.html5.Div;
import org.apache.juneau.bean.html5.HtmlBuilder;
import org.apache.juneau.bean.html5.HtmlElement;
import org.apache.juneau.bean.html5.Select;
import org.apache.juneau.bean.html5.Table;
import org.apache.juneau.bean.html5.Td;
import org.apache.juneau.bean.openapi3.Contact;
import org.apache.juneau.bean.openapi3.ExternalDocumentation;
import org.apache.juneau.bean.openapi3.Info;
import org.apache.juneau.bean.openapi3.License;
import org.apache.juneau.bean.openapi3.OpenApi;
import org.apache.juneau.bean.openapi3.Operation;
import org.apache.juneau.bean.openapi3.Parameter;
import org.apache.juneau.bean.openapi3.Response;
import org.apache.juneau.bean.openapi3.SchemaInfo;
import org.apache.juneau.bean.openapi3.Tag;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.swap.ObjectSwap;

public class OpenApiUI
extends ObjectSwap<OpenApi, Div> {
    static final FileFinder RESOURCES = (FileFinder)FileFinder.create((BeanStore)BeanStore.INSTANCE).cp(OpenApiUI.class, null, true).dir(",").caching(Boolean.getBoolean("RestContext.disableClasspathResourceCaching.b") ? -1L : 1000000L).build();
    private static final Set<String> STANDARD_METHODS = CollectionUtils.set((Object[])new String[]{"get", "put", "post", "delete", "options", "head", "patch", "trace"});

    private static void addOperationIfTagMatches(Div tagBlockContents, Session s, String path, String method, Operation op, Tag t) {
        if (t == null && (op.getTags() == null || op.getTags().isEmpty()) || Utils.nn((Object)t) && Utils.nn(op.getTags()) && op.getTags().contains(t.getName())) {
            tagBlockContents.child((Object)OpenApiUI.opBlock(s, path, method, op));
        }
    }

    private static Div examples(Session s, Parameter pi) {
        JsonMap m = new JsonMap();
        try {
            SchemaInfo si = pi.getSchema();
            if (Utils.nn((Object)si)) {
                m.put("model", (Object)si.copy().resolveRefs(s.openApi, new ArrayDeque<String>(), s.resolveRefsMaxDepth));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (m.isEmpty()) {
            return null;
        }
        return OpenApiUI.examplesDiv(m);
    }

    private static Div examples(Session s, Response ri) {
        JsonMap m = new JsonMap();
        try {
            Map<String, org.apache.juneau.bean.openapi3.MediaType> content = ri.getContent();
            if (Utils.nn(content)) {
                content.forEach((mediaType, mediaTypeObj) -> {
                    if (Utils.nn((Object)mediaTypeObj.getSchema())) {
                        try {
                            SchemaInfo schema = mediaTypeObj.getSchema().copy().resolveRefs(s.openApi, new ArrayDeque<String>(), s.resolveRefsMaxDepth);
                            m.put(mediaType, (Object)schema);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (m.isEmpty()) {
            return null;
        }
        return OpenApiUI.examplesDiv(m);
    }

    private static Div examplesDiv(JsonMap m) {
        if (m.isEmpty()) {
            return null;
        }
        Select select = null;
        if (m.size() > 1) {
            select = HtmlBuilder.select().onchange("selectExample(this)")._class("example-select");
        }
        Div div = HtmlBuilder.div((Object[])new Object[]{select})._class("examples");
        if (Utils.nn((Object)select)) {
            select.child((Object)HtmlBuilder.option((Object)"model", (Object)"model"));
        }
        div.child((Object)HtmlBuilder.div((Object[])new Object[]{m.remove((Object)"model")})._class("model active").attr("data-name", (Object)"model"));
        Select select2 = select;
        m.forEach((k, v) -> {
            if (Utils.nn((Object)select2)) {
                select2.child((Object)HtmlBuilder.option((Object)k, (Object)k));
            }
            div.child((Object)HtmlBuilder.div((Object[])new Object[]{v.toString().replace("\\n", "\n")})._class("example").attr("data-name", k));
        });
        return div;
    }

    private static Table header(Session s) {
        Table table = HtmlBuilder.table()._class("header");
        Info info = s.openApi.getInfo();
        if (Utils.nn((Object)info)) {
            String child;
            ExternalDocumentation ed;
            License l;
            Contact c;
            if (Utils.nn((Object)info.getDescription())) {
                table.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Description:"}), HtmlBuilder.td((Object[])new Object[]{OpenApiUI.toBRL(info.getDescription())})}));
            }
            if (Utils.nn((Object)info.getVersion())) {
                table.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Version:"}), HtmlBuilder.td((Object[])new Object[]{info.getVersion()})}));
            }
            if (Utils.nn((Object)(c = info.getContact()))) {
                Table t2 = HtmlBuilder.table();
                if (Utils.nn((Object)c.getName())) {
                    t2.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Name:"}), HtmlBuilder.td((Object[])new Object[]{c.getName()})}));
                }
                if (Utils.nn((Object)c.getUrl())) {
                    t2.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"URL:"}), HtmlBuilder.td((Object[])new Object[]{HtmlBuilder.a((Object)c.getUrl(), (Object[])new Object[]{c.getUrl()})})}));
                }
                if (Utils.nn((Object)c.getEmail())) {
                    t2.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Email:"}), HtmlBuilder.td((Object[])new Object[]{HtmlBuilder.a((Object)("mailto:" + c.getEmail()), (Object[])new Object[]{c.getEmail()})})}));
                }
                table.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Contact:"}), HtmlBuilder.td((Object[])new Object[]{t2})}));
            }
            if (Utils.nn((Object)(l = info.getLicense()))) {
                Object content = Utils.nn((Object)l.getName()) ? l.getName() : l.getUrl();
                String child2 = Utils.nn((Object)l.getUrl()) ? HtmlBuilder.a((Object)l.getUrl(), (Object[])new Object[]{content}) : l.getName();
                table.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"License:"}), HtmlBuilder.td((Object[])new Object[]{child2})}));
            }
            if (Utils.nn((Object)(ed = s.openApi.getExternalDocs()))) {
                Object content = Utils.nn((Object)ed.getDescription()) ? ed.getDescription() : ed.getUrl();
                child = Utils.nn((Object)ed.getUrl()) ? HtmlBuilder.a((Object)ed.getUrl(), (Object[])new Object[]{content}) : ed.getDescription();
                table.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Docs:"}), HtmlBuilder.td((Object[])new Object[]{child})}));
            }
            if (Utils.nn((Object)info.getTermsOfService())) {
                String tos = info.getTermsOfService();
                child = StringUtils.isUri((String)tos) ? HtmlBuilder.a((Object)tos, (Object[])new Object[]{tos}) : tos;
                table.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Terms of Service:"}), HtmlBuilder.td((Object[])new Object[]{child})}));
            }
        }
        return table;
    }

    private static Div headers(Response ri) {
        if (ri.getHeaders() == null) {
            return null;
        }
        Table sectionTable = HtmlBuilder.table((Object[])new Object[]{HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Name"}), HtmlBuilder.th((Object[])new Object[]{"Description"}), HtmlBuilder.th((Object[])new Object[]{"Schema"})})})._class("section-table");
        Div headers = HtmlBuilder.div((Object[])new Object[]{HtmlBuilder.div((Object[])new Object[]{"Headers:"})._class("section-name"), sectionTable})._class("headers");
        ri.getHeaders().forEach((k, v) -> sectionTable.child((Object)HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.td((Object[])new Object[]{k})._class("name"), HtmlBuilder.td((Object[])new Object[]{OpenApiUI.toBRL(v.getDescription())})._class("description"), HtmlBuilder.td((Object[])new Object[]{v.asMap().keepAll(new String[]{"type", "format", "items", "collectionFormat", "default", "maximum", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "enum", "multipleOf"})})})));
        return headers;
    }

    private static Div modelBlock(String modelName, SchemaInfo model) {
        return HtmlBuilder.div()._class("op-block op-block-closed model").children(new Object[]{OpenApiUI.modelBlockSummary(modelName, model), HtmlBuilder.div((Object[])new Object[]{model})._class("op-block-contents")});
    }

    private static HtmlElement modelBlockSummary(String modelName, SchemaInfo model) {
        return HtmlBuilder.div()._class("op-block-summary").onclick("toggleOpBlock(this)").children(new Object[]{HtmlBuilder.span((Object[])new Object[]{modelName})._class("method-button"), Utils.nn((Object)model.getDescription()) ? HtmlBuilder.span((Object[])new Object[]{OpenApiUI.toBRL(model.getDescription())})._class("summary") : null});
    }

    private static Div modelsBlockContents(Session s) {
        Div modelBlockContents = HtmlBuilder.div()._class("tag-block-contents");
        if (Utils.nn((Object)s.openApi.getComponents()) && Utils.nn(s.openApi.getComponents().getSchemas())) {
            s.openApi.getComponents().getSchemas().forEach((k, v) -> modelBlockContents.child((Object)OpenApiUI.modelBlock(k, v)));
        }
        return modelBlockContents;
    }

    private static HtmlElement modelsBlockSummary() {
        return HtmlBuilder.div()._class("tag-block-summary").onclick("toggleTagBlock(this)").children(new Object[]{HtmlBuilder.span((Object[])new Object[]{"Models"})._class("name")});
    }

    private static Div opBlock(Session s, String path, String opName, Operation op) {
        String opClass;
        String string = opClass = Utils.nn((Object)op.getDeprecated()) && op.getDeprecated() != false ? "deprecated" : opName.toLowerCase();
        if (!(Utils.nn((Object)op.getDeprecated()) && op.getDeprecated().booleanValue() || STANDARD_METHODS.contains(opClass))) {
            opClass = "other";
        }
        return HtmlBuilder.div()._class("op-block op-block-closed " + opClass).children(new Object[]{OpenApiUI.opBlockSummary(path, opName, op), HtmlBuilder.div((Object[])new Object[]{OpenApiUI.tableContainer(s, op)})._class("op-block-contents")});
    }

    private static HtmlElement opBlockSummary(String path, String opName, Operation op) {
        return HtmlBuilder.div()._class("op-block-summary").onclick("toggleOpBlock(this)").children(new Object[]{HtmlBuilder.span((Object[])new Object[]{opName.toUpperCase()})._class("method-button"), HtmlBuilder.span((Object[])new Object[]{path})._class("path"), Utils.nn((Object)op.getSummary()) ? HtmlBuilder.span((Object[])new Object[]{op.getSummary()})._class("summary") : null});
    }

    private static Div tableContainer(Session s, Operation op) {
        Div tableContainer = HtmlBuilder.div()._class("table-container");
        if (Utils.nn((Object)op.getDescription())) {
            tableContainer.child((Object)HtmlBuilder.div((Object[])new Object[]{OpenApiUI.toBRL(op.getDescription())})._class("op-block-description"));
        }
        if (Utils.nn(op.getParameters())) {
            tableContainer.child((Object)HtmlBuilder.div((Object[])new Object[]{HtmlBuilder.h4((Object[])new Object[]{"Parameters"})._class("title")})._class("op-block-section-header"));
            Table parameters = HtmlBuilder.table((Object[])new Object[]{HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Name"})._class("parameter-key"), HtmlBuilder.th((Object[])new Object[]{"Description"})._class("parameter-key")})})._class("parameters");
            op.getParameters().forEach(x -> {
                String piName = x.getName();
                boolean required = Utils.nn((Object)x.getRequired()) && x.getRequired() != false;
                Td parameterKey = HtmlBuilder.td((Object[])new Object[]{HtmlBuilder.div((Object[])new Object[]{piName})._class("name" + (required ? " required" : "")), required ? HtmlBuilder.div((Object[])new Object[]{"required"})._class("requiredlabel") : null, Utils.nn((Object)x.getSchema()) ? HtmlBuilder.div((Object[])new Object[]{x.getSchema().getType()})._class("type") : null, HtmlBuilder.div((Object[])new Object[]{"(" + x.getIn() + ")"})._class("in")})._class("parameter-key");
                Td parameterValue = HtmlBuilder.td((Object[])new Object[]{HtmlBuilder.div((Object[])new Object[]{OpenApiUI.toBRL(x.getDescription())})._class("description"), OpenApiUI.examples(s, x)})._class("parameter-value");
                parameters.child((Object)HtmlBuilder.tr((Object[])new Object[]{parameterKey, parameterValue}));
            });
            tableContainer.child((Object)parameters);
        }
        if (Utils.nn(op.getResponses())) {
            tableContainer.child((Object)HtmlBuilder.div((Object[])new Object[]{HtmlBuilder.h4((Object[])new Object[]{"Responses"})._class("title")})._class("op-block-section-header"));
            Table responses = HtmlBuilder.table((Object[])new Object[]{HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th((Object[])new Object[]{"Code"})._class("response-key"), HtmlBuilder.th((Object[])new Object[]{"Description"})._class("response-key")})})._class("responses");
            tableContainer.child((Object)responses);
            op.getResponses().forEach((k, v) -> {
                Td code = HtmlBuilder.td((Object[])new Object[]{k})._class("response-key");
                Td codeValue = HtmlBuilder.td((Object[])new Object[]{HtmlBuilder.div((Object[])new Object[]{OpenApiUI.toBRL(v.getDescription())})._class("description"), OpenApiUI.examples(s, v), OpenApiUI.headers(v)})._class("response-value");
                responses.child((Object)HtmlBuilder.tr((Object[])new Object[]{code, codeValue}));
            });
        }
        return tableContainer;
    }

    private static Div tagBlockContents(Session s, Tag t) {
        Div tagBlockContents = HtmlBuilder.div()._class("tag-block-contents");
        if (Utils.nn(s.openApi.getPaths())) {
            s.openApi.getPaths().forEach((path, pathItem) -> {
                if (Utils.nn((Object)pathItem.getGet())) {
                    OpenApiUI.addOperationIfTagMatches(tagBlockContents, s, path, "get", pathItem.getGet(), t);
                }
                if (Utils.nn((Object)pathItem.getPut())) {
                    OpenApiUI.addOperationIfTagMatches(tagBlockContents, s, path, "put", pathItem.getPut(), t);
                }
                if (Utils.nn((Object)pathItem.getPost())) {
                    OpenApiUI.addOperationIfTagMatches(tagBlockContents, s, path, "post", pathItem.getPost(), t);
                }
                if (Utils.nn((Object)pathItem.getDelete())) {
                    OpenApiUI.addOperationIfTagMatches(tagBlockContents, s, path, "delete", pathItem.getDelete(), t);
                }
                if (Utils.nn((Object)pathItem.getOptions())) {
                    OpenApiUI.addOperationIfTagMatches(tagBlockContents, s, path, "options", pathItem.getOptions(), t);
                }
                if (Utils.nn((Object)pathItem.getHead())) {
                    OpenApiUI.addOperationIfTagMatches(tagBlockContents, s, path, "head", pathItem.getHead(), t);
                }
                if (Utils.nn((Object)pathItem.getPatch())) {
                    OpenApiUI.addOperationIfTagMatches(tagBlockContents, s, path, "patch", pathItem.getPatch(), t);
                }
                if (Utils.nn((Object)pathItem.getTrace())) {
                    OpenApiUI.addOperationIfTagMatches(tagBlockContents, s, path, "trace", pathItem.getTrace(), t);
                }
            });
        }
        return tagBlockContents;
    }

    private static HtmlElement tagBlockSummary(Tag t) {
        ExternalDocumentation ed = t.getExternalDocs();
        URI content = Utils.nn((Object)ed) && Utils.nn((Object)ed.getDescription()) ? ed.getDescription() : (Utils.nn((Object)ed) ? ed.getUrl() : null);
        return HtmlBuilder.div()._class("tag-block-summary").onclick("toggleTagBlock(this)").children(new Object[]{HtmlBuilder.span((Object[])new Object[]{t.getName()})._class("name"), HtmlBuilder.span((Object[])new Object[]{OpenApiUI.toBRL(t.getDescription())})._class("description"), Utils.nn((Object)ed) && Utils.nn((Object)ed.getUrl()) ? HtmlBuilder.span((Object[])new Object[]{HtmlBuilder.a((Object)ed.getUrl(), (Object[])new Object[]{content})})._class("extdocs") : null});
    }

    private static List<Object> toBRL(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(44) == -1) {
            return Collections.singletonList(s);
        }
        List l = CollectionUtils.list((Object[])new Object[0]);
        String[] sa = s.split("\n");
        for (int i = 0; i < sa.length; ++i) {
            if (i > 0) {
                l.add(HtmlBuilder.br());
            }
            l.add(sa[i]);
        }
        return l;
    }

    public MediaType[] forMediaTypes() {
        return (MediaType[])CollectionUtils.a((Object[])new MediaType[]{MediaType.HTML});
    }

    public Div swap(BeanSession beanSession, OpenApi openApi) throws Exception {
        Session s = new Session(openApi);
        String css = RESOURCES.getString("files/htdocs/styles/OpenApiUI.css", null).orElse(null);
        if (css == null) {
            css = RESOURCES.getString("OpenApiUI.css", null).orElse(null);
        }
        Div outer = HtmlBuilder.div((Object[])new Object[]{HtmlBuilder.style((Object)css), HtmlBuilder.script((String)"text/javascript", (String[])new String[]{RESOURCES.getString("OpenApiUI.js", null).orElse(null)}), OpenApiUI.header(s)})._class("openapi-ui");
        outer.child((Object)HtmlBuilder.div()._class("tag-block tag-block-open").children(new Object[]{OpenApiUI.tagBlockContents(s, null)}));
        if (Utils.nn(s.openApi.getTags())) {
            s.openApi.getTags().forEach(x -> {
                Div tagBlock = HtmlBuilder.div()._class("tag-block tag-block-open").children(new Object[]{OpenApiUI.tagBlockSummary(x), OpenApiUI.tagBlockContents(s, x)});
                outer.child((Object)tagBlock);
            });
        }
        if (Utils.nn((Object)s.openApi.getComponents()) && Utils.nn(s.openApi.getComponents().getSchemas())) {
            Div modelBlock = HtmlBuilder.div()._class("tag-block").children(new Object[]{OpenApiUI.modelsBlockSummary(), OpenApiUI.modelsBlockContents(s)});
            outer.child((Object)modelBlock);
        }
        return outer;
    }

    private static class Session {
        final int resolveRefsMaxDepth;
        final OpenApi openApi;

        Session(OpenApi openApi) {
            this.openApi = openApi.copy();
            this.resolveRefsMaxDepth = 1;
        }
    }
}

