/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.blackbird.deser;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.module.blackbird.deser.CreatorOptimizer;
import com.fasterxml.jackson.module.blackbird.deser.ObjBooleanConsumer;
import com.fasterxml.jackson.module.blackbird.deser.OptimizedSettableBeanProperty;
import com.fasterxml.jackson.module.blackbird.deser.SettableBooleanProperty;
import com.fasterxml.jackson.module.blackbird.deser.SettableIntProperty;
import com.fasterxml.jackson.module.blackbird.deser.SettableLongProperty;
import com.fasterxml.jackson.module.blackbird.deser.SettableObjectProperty;
import com.fasterxml.jackson.module.blackbird.deser.SettableStringProperty;
import com.fasterxml.jackson.module.blackbird.deser.SuperSonicBeanDeserializer;
import com.fasterxml.jackson.module.blackbird.deser.SuperSonicDeserializerBuilder;
import com.fasterxml.jackson.module.blackbird.util.ReflectionHack;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.UnaryOperator;

public class BBDeserializerModifier
extends BeanDeserializerModifier {
    private static final MethodHandle TRAMPOLINE;
    private static final MethodHandle BOOLEAN_TRAMPOLINE;
    private static final MethodHandle LONG_TRAMPOLINE;
    private static final MethodHandle INT_TRAMPOLINE;
    private final Function<Class<?>, MethodHandles.Lookup> _lookups;
    private final UnaryOperator<MethodHandles.Lookup> _accessGrant;

    public BBDeserializerModifier(Function<Class<?>, MethodHandles.Lookup> lookups, UnaryOperator<MethodHandles.Lookup> accessGrant) {
        this._lookups = lookups;
        this._accessGrant = accessGrant;
    }

    public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
        ValueInstantiator inst;
        Class beanClass = beanDesc.getBeanClass();
        MethodHandles.Lookup lookup = this._lookups.apply(beanClass);
        if (lookup == null) {
            return builder;
        }
        try {
            lookup = ReflectionHack.privateLookupIn(beanClass, lookup);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (Modifier.isPrivate(beanClass.getModifiers())) {
            return builder;
        }
        List<OptimizedSettableBeanProperty<?>> newProps = this.findOptimizableProperties(lookup = (MethodHandles.Lookup)this._accessGrant.apply(lookup), config, builder.getProperties());
        if (!newProps.isEmpty()) {
            for (OptimizedSettableBeanProperty<?> prop : newProps) {
                builder.addOrReplaceProperty(prop, true);
            }
        }
        if ((inst = builder.getValueInstantiator()).getClass() == StdValueInstantiator.class && (inst.canCreateUsingDefault() || inst.canCreateFromObjectWith()) && (inst = new CreatorOptimizer(beanClass, lookup, (StdValueInstantiator)inst).createOptimized()) != null) {
            builder.setValueInstantiator(inst);
        }
        if (builder.getClass() == BeanDeserializerBuilder.class) {
            return new SuperSonicDeserializerBuilder(builder);
        }
        return builder;
    }

    protected List<OptimizedSettableBeanProperty<?>> findOptimizableProperties(MethodHandles.Lookup lookup, DeserializationConfig config, Iterator<SettableBeanProperty> propIterator) {
        ArrayList newProps = new ArrayList();
        while (propIterator.hasNext()) {
            try {
                this.nextProperty(propIterator.next(), lookup, newProps);
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        return newProps;
    }

    private void nextProperty(SettableBeanProperty prop, MethodHandles.Lookup lookup, ArrayList<OptimizedSettableBeanProperty<?>> newProps) throws Throwable {
        AnnotatedMember member = prop.getMember();
        Member jdkMember = member.getMember();
        if (jdkMember == null) {
            return;
        }
        if (Modifier.isPrivate(jdkMember.getModifiers())) {
            return;
        }
        if (prop.hasValueDeserializer() && !this.isDefaultDeserializer(prop.getValueDeserializer())) {
            return;
        }
        if (!(jdkMember instanceof Method) || !(prop instanceof MethodProperty)) {
            return;
        }
        Method method = (Method)jdkMember;
        MethodHandle setter = lookup.unreflect(method);
        Class type = ((AnnotatedMethod)member).getRawParameterType(0);
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                newProps.add(new SettableIntProperty(prop, this.createSetter(lookup, ObjIntConsumer.class, ObjIntBiFunction.class, INT_TRAMPOLINE, Integer.TYPE, setter)));
            } else if (type == Long.TYPE) {
                newProps.add(new SettableLongProperty(prop, this.createSetter(lookup, ObjLongConsumer.class, ObjLongBiFunction.class, LONG_TRAMPOLINE, Long.TYPE, setter)));
            } else if (type == Boolean.TYPE) {
                newProps.add(new SettableBooleanProperty(prop, this.createSetter(lookup, ObjBooleanConsumer.class, ObjBooleanBiFunction.class, BOOLEAN_TRAMPOLINE, Boolean.TYPE, setter)));
            }
        } else if (type == String.class) {
            newProps.add(new SettableStringProperty(prop, this.createSetter(lookup, BiConsumer.class, BiFunction.class, TRAMPOLINE, Object.class, setter)));
        } else {
            newProps.add(new SettableObjectProperty(prop, this.createSetter(lookup, BiConsumer.class, BiFunction.class, TRAMPOLINE, Object.class, setter)));
        }
    }

    private <T> T createSetter(MethodHandles.Lookup lookup, Class<T> iface, Class<?> thunkType, MethodHandle trampoline, Class<?> valueType, MethodHandle setter) throws Throwable, LambdaConversionException {
        if (setter.type().returnType() == Void.TYPE) {
            return iface.cast(LambdaMetafactory.metafactory(lookup, "accept", MethodType.methodType(iface), MethodType.methodType(Void.TYPE, Object.class, valueType), setter, setter.type()).getTarget().invoke());
        }
        Object builtThunk = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(thunkType), MethodType.methodType(Object.class, Object.class, valueType), setter, setter.type()).getTarget().invoke();
        return iface.cast(LambdaMetafactory.metafactory(MethodHandles.lookup(), "accept", MethodType.methodType(iface, thunkType), MethodType.methodType(Void.TYPE, Object.class, valueType), trampoline, MethodType.methodType(Void.TYPE, Object.class, valueType)).getTarget().invoke(builtThunk));
    }

    protected boolean isDefaultDeserializer(JsonDeserializer<?> deser) {
        return ClassUtil.isJacksonStdImpl(deser) || deser instanceof SuperSonicBeanDeserializer;
    }

    static void intTrampoline(ObjIntBiFunction thunk, Object bean, int value) {
        thunk.apply(bean, value);
    }

    static void longTrampoline(ObjLongBiFunction thunk, Object bean, long value) {
        thunk.apply(bean, value);
    }

    static void booleanTrampoline(ObjBooleanBiFunction thunk, Object bean, boolean value) {
        thunk.apply(bean, value);
    }

    static void trampoline(BiFunction<Object, Object, Object> thunk, Object bean, Object value) {
        thunk.apply(bean, value);
    }

    static {
        try {
            TRAMPOLINE = MethodHandles.lookup().findStatic(BBDeserializerModifier.class, "trampoline", MethodType.methodType(Void.TYPE, BiFunction.class, Object.class, Object.class));
            BOOLEAN_TRAMPOLINE = MethodHandles.lookup().findStatic(BBDeserializerModifier.class, "booleanTrampoline", MethodType.methodType(Void.TYPE, ObjBooleanBiFunction.class, Object.class, Boolean.TYPE));
            LONG_TRAMPOLINE = MethodHandles.lookup().findStatic(BBDeserializerModifier.class, "longTrampoline", MethodType.methodType(Void.TYPE, ObjLongBiFunction.class, Object.class, Long.TYPE));
            INT_TRAMPOLINE = MethodHandles.lookup().findStatic(BBDeserializerModifier.class, "intTrampoline", MethodType.methodType(Void.TYPE, ObjIntBiFunction.class, Object.class, Integer.TYPE));
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @FunctionalInterface
    public static interface ObjBooleanBiFunction {
        public Object apply(Object var1, boolean var2);
    }

    @FunctionalInterface
    public static interface ObjLongBiFunction {
        public Object apply(Object var1, long var2);
    }

    @FunctionalInterface
    public static interface ObjIntBiFunction {
        public Object apply(Object var1, int var2);
    }
}

