/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.share.generated;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.coordinator.share.generated.ShareUpdateKey;

public class ShareUpdateKeyJsonConverter {
    public static ShareUpdateKey read(JsonNode _node, short _version) {
        ShareUpdateKey _object = new ShareUpdateKey();
        JsonNode _groupIdNode = _node.get("groupId");
        if (_groupIdNode == null) {
            throw new RuntimeException("ShareUpdateKey: unable to locate field 'groupId', which is mandatory in version " + _version);
        }
        if (!_groupIdNode.isTextual()) {
            throw new RuntimeException("ShareUpdateKey expected a string type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.groupId = _groupIdNode.asText();
        JsonNode _topicIdNode = _node.get("topicId");
        if (_topicIdNode == null) {
            throw new RuntimeException("ShareUpdateKey: unable to locate field 'topicId', which is mandatory in version " + _version);
        }
        if (!_topicIdNode.isTextual()) {
            throw new RuntimeException("ShareUpdateKey expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.topicId = Uuid.fromString((String)_topicIdNode.asText());
        JsonNode _partitionNode = _node.get("partition");
        if (_partitionNode == null) {
            throw new RuntimeException("ShareUpdateKey: unable to locate field 'partition', which is mandatory in version " + _version);
        }
        _object.partition = MessageUtil.jsonNodeToInt((JsonNode)_partitionNode, (String)"ShareUpdateKey");
        return _object;
    }

    public static JsonNode write(ShareUpdateKey _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("groupId", (JsonNode)new TextNode(_object.groupId));
        _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
        _node.set("partition", (JsonNode)new IntNode(_object.partition));
        return _node;
    }

    public static JsonNode write(ShareUpdateKey _object, short _version) {
        return ShareUpdateKeyJsonConverter.write(_object, _version, true);
    }
}

