/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jms.config.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import org.ops4j.pax.jms.config.ConfigLoader;
import org.ops4j.pax.jms.config.impl.ConnectionFactoryConfigManager;
import org.ops4j.pax.jms.config.impl.ConnectionFactoryWrapper;
import org.ops4j.pax.jms.config.impl.ExternalConfigLoader;
import org.ops4j.pax.jms.config.impl.FileConfigLoader;
import org.ops4j.pax.jms.config.impl.ServiceTrackerHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final String FACTORY_PID = "org.ops4j.connectionfactory";
    private ServiceTracker<?, ?> connectionFactoryTracker;
    private ExternalConfigLoader externalConfigLoader;
    private ServiceRegistration<ConfigLoader> configLoaderRegistration;
    private ConnectionFactoryConfigManager configManager;
    private ServiceRegistration<ManagedServiceFactory> registration;

    public void start(BundleContext context) throws Exception {
        this.configLoaderRegistration = context.registerService(ConfigLoader.class, (Object)new FileConfigLoader(), new Hashtable());
        this.externalConfigLoader = new ExternalConfigLoader(context);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", FACTORY_PID);
        this.configManager = new ConnectionFactoryConfigManager(context, this.externalConfigLoader);
        this.registration = context.registerService(ManagedServiceFactory.class, (Object)this.configManager, props);
        ServiceTrackerHelper helper = ServiceTrackerHelper.helper(context);
        String filter = "(&(pool=*)(!(pax.jms.managed=true))(|(objectClass=javax.jms.ConnectionFactory)(objectClass=javax.jms.XAConnectionFactory)))";
        this.connectionFactoryTracker = helper.track(Object.class, filter, (cf, reference) -> new ConnectionFactoryWrapper(context, this.externalConfigLoader, cf, (ServiceReference<Object>)reference), ConnectionFactoryWrapper::close);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.connectionFactoryTracker != null) {
            this.connectionFactoryTracker.close();
        }
        this.registration.unregister();
        this.configManager.destroy();
        this.configLoaderRegistration.unregister();
        this.externalConfigLoader.destroy();
    }
}

