/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.modify;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreModifyRequestObjectName
extends GrammarAction<LdapMessageContainer<ModifyRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreModifyRequestObjectName.class);

    public StoreModifyRequestObjectName() {
        super("Store Modify request object Name");
    }

    public void action(LdapMessageContainer<ModifyRequest> container) throws DecoderException {
        ModifyRequest modifyRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Dn object = Dn.EMPTY_DN;
        if (tlv.getLength() == 0) {
            modifyRequest.setName(object);
        } else {
            byte[] dnBytes = tlv.getValue().getData();
            String dnStr = Strings.utf8ToString((byte[])dnBytes);
            try {
                object = new Dn(new String[]{dnStr});
            }
            catch (LdapInvalidDnException ine) {
                String msg = I18n.err((I18n)I18n.ERR_05113_INVALID_DN, (Object[])new Object[]{dnStr, Strings.dumpBytes((byte[])dnBytes)});
                LOG.error(I18n.err((I18n)I18n.ERR_05114_ERROR_MESSAGE, (Object[])new Object[]{msg, ine.getMessage()}));
                ModifyResponseImpl response = new ModifyResponseImpl(modifyRequest.getMessageId());
                throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
            }
            modifyRequest.setName(object);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05132_DN_MODIFICATION, (Object[])new Object[]{modifyRequest.getName()}));
        }
    }
}

