/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.ControlsContainer;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreControlValue
extends GrammarAction<ControlsContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreControlValue.class);

    public StoreControlValue() {
        super("Store the control value");
    }

    public void action(ControlsContainer container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        Control control = container.getCurrentControl();
        ControlFactory<?> controlFactory = container.getFactory();
        BerValue value = tlv.getValue();
        try {
            if (tlv.getLength() == 0) {
                controlFactory.decodeValue(control, Strings.EMPTY_BYTES);
            } else {
                controlFactory.decodeValue(control, value.getData());
            }
        }
        catch (DecoderException de) {
            String message = I18n.err((I18n)I18n.ERR_08109_BAD_CONTROL_VALUE, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())});
            LOG.error(message);
            throw new DecoderException(message, (Throwable)de);
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_08203_CONTROL_VALUE, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())}));
        }
    }
}

