/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GroupByColumn;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.OrderedColumnList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

class GroupByList
extends OrderedColumnList<GroupByColumn> {
    int numGroupingColsAdded = 0;
    boolean rollup = false;

    public GroupByList(ContextManager contextManager) {
        super(GroupByColumn.class, contextManager);
    }

    void addGroupByColumn(GroupByColumn groupByColumn) {
        this.addElement(groupByColumn);
    }

    GroupByColumn getGroupByColumn(int n) {
        return (GroupByColumn)this.elementAt(n);
    }

    void setRollup() {
        this.rollup = true;
    }

    boolean isRollup() {
        return this.rollup;
    }

    int getNumNeedToAddGroupingCols() {
        return this.numGroupingColsAdded;
    }

    void bindGroupByColumns(SelectNode selectNode, List<AggregateNode> list) throws StandardException {
        FromList fromList = selectNode.getFromList();
        ResultColumnList resultColumnList = selectNode.getResultColumns();
        SubqueryList subqueryList = new SubqueryList(this.getContextManager());
        int n = 0;
        if (this.size() > 32677) {
            throw StandardException.newException("54004", new Object[0]);
        }
        for (Object object : this) {
            ((GroupByColumn)object).bindExpression(fromList, subqueryList, list);
        }
        int n2 = resultColumnList.size();
        for (GroupByColumn groupByColumn : this) {
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                ColumnReference columnReference;
                ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
                if (!(resultColumn.getExpression() instanceof ColumnReference) || !(columnReference = (ColumnReference)resultColumn.getExpression()).isEquivalent(groupByColumn.getColumnExpression())) continue;
                groupByColumn.setColumnPosition(i + 1);
                resultColumn.markAsGroupingColumn();
                bl = true;
                break;
            }
            if (!bl && !selectNode.hasDistinct() && groupByColumn.getColumnExpression() instanceof ColumnReference) {
                ResultColumn resultColumn = new ResultColumn(groupByColumn.getColumnName(), groupByColumn.getColumnExpression().getClone(), this.getContextManager());
                resultColumn.setVirtualColumnId(resultColumnList.size() + 1);
                resultColumn.markGenerated();
                resultColumn.markAsGroupingColumn();
                resultColumnList.addElement(resultColumn);
                groupByColumn.setColumnPosition(resultColumnList.size());
                resultColumnList.setCountMismatchAllowed(true);
                ++n;
            }
            if (!(groupByColumn.getColumnExpression() instanceof JavaToSQLValueNode)) continue;
            throw StandardException.newException("42Y30", new Object[0]);
        }
        if (subqueryList.size() != 0) {
            throw StandardException.newException("42Y26.S.1", new Object[0]);
        }
        this.numGroupingColsAdded += n;
    }

    GroupByColumn findGroupingColumn(ValueNode valueNode) throws StandardException {
        for (GroupByColumn groupByColumn : this) {
            if (!groupByColumn.getColumnExpression().isEquivalent(valueNode)) continue;
            return groupByColumn;
        }
        return null;
    }

    void remapColumnReferencesToExpressions() throws StandardException {
        for (GroupByColumn groupByColumn : this) {
            groupByColumn.setColumnExpression(groupByColumn.getColumnExpression().remapColumnReferencesToExpressions());
        }
    }

    @Override
    public String toString() {
        return "";
    }

    void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        for (GroupByColumn groupByColumn : this) {
            groupByColumn.setColumnExpression(groupByColumn.getColumnExpression().preprocess(n, fromList, subqueryList, predicateList));
        }
    }
}

