/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.subtree;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.StringReader;
import java.text.ParseException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.NormalizerMappingResolver;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.subtree.ReusableAntlrSubtreeSpecificationLexer;
import org.apache.directory.api.ldap.model.subtree.ReusableAntlrSubtreeSpecificationParser;
import org.apache.directory.api.ldap.model.subtree.SubtreeSpecification;
import org.apache.directory.api.util.Strings;

public class SubtreeSpecificationParser {
    private ReusableAntlrSubtreeSpecificationParser parser;
    private ReusableAntlrSubtreeSpecificationLexer lexer;
    private final boolean isNormalizing;

    public SubtreeSpecificationParser(SchemaManager schemaManager) {
        StringReader in = new StringReader("");
        this.lexer = new ReusableAntlrSubtreeSpecificationLexer(in);
        this.parser = new ReusableAntlrSubtreeSpecificationParser(this.lexer);
        this.parser.init(schemaManager);
        this.isNormalizing = false;
    }

    public SubtreeSpecificationParser(NormalizerMappingResolver resolver, SchemaManager schemaManager) {
        StringReader in = new StringReader("");
        this.lexer = new ReusableAntlrSubtreeSpecificationLexer(in);
        this.parser = new ReusableAntlrSubtreeSpecificationParser(this.lexer);
        this.parser.setNormalizerMappingResolver(resolver);
        this.parser.init(schemaManager);
        this.isNormalizing = true;
    }

    private synchronized void reset(String spec) {
        StringReader in = new StringReader(spec + "end");
        this.lexer.prepareNextInput(in);
        this.parser.resetState();
    }

    public synchronized SubtreeSpecification parse(String spec) throws ParseException {
        SubtreeSpecification ss;
        if (spec == null || Strings.isEmpty((String)spec.trim())) {
            return null;
        }
        this.reset(spec);
        try {
            ss = this.parser.wrapperEntryPoint();
        }
        catch (RecognitionException | TokenStreamException e) {
            String msg = I18n.err((I18n)I18n.ERR_13028_SUBTREE_SPEC_PARSER_FAILURE, (Object[])new Object[]{spec, e.getLocalizedMessage()});
            throw new ParseException(msg, 0);
        }
        return ss;
    }

    public boolean isNormizing() {
        return this.isNormalizing;
    }
}

