/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.credentials.authenticator;

import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuth1RequestToken;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.pac4j.oauth.credentials.OAuth10Credentials;
import org.pac4j.oauth.credentials.OAuthCredentials;
import org.pac4j.oauth.credentials.authenticator.OAuthAuthenticator;
import org.pac4j.oauth.exception.OAuthCredentialsException;

public class OAuth10Authenticator
extends OAuthAuthenticator<OAuth10Credentials, OAuth10Configuration> {
    public OAuth10Authenticator(OAuth10Configuration configuration, IndirectClient client) {
        super(configuration, client);
    }

    @Override
    protected void retrieveAccessToken(WebContext context, OAuthCredentials credentials) {
        OAuth1AccessToken accessToken;
        OAuth10Credentials oAuth10Credentials = (OAuth10Credentials)credentials;
        OAuth1RequestToken tokenRequest = oAuth10Credentials.getRequestToken();
        String token = oAuth10Credentials.getToken();
        String verifier = oAuth10Credentials.getVerifier();
        this.logger.debug("tokenRequest: {}", (Object)tokenRequest);
        this.logger.debug("token: {}", (Object)token);
        this.logger.debug("verifier: {}", (Object)verifier);
        if (tokenRequest == null) {
            String message = "Token request expired";
            throw new OAuthCredentialsException("Token request expired");
        }
        String savedToken = tokenRequest.getToken();
        this.logger.debug("savedToken: {}", (Object)savedToken);
        if (savedToken == null || !savedToken.equals(token)) {
            String message = "Token received: " + token + " is different from saved token: " + savedToken;
            throw new OAuthCredentialsException(message);
        }
        try {
            accessToken = ((OAuth10Configuration)this.configuration).buildService(context, this.client).getAccessToken(tokenRequest, verifier);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new HttpCommunicationException("Error getting token:" + e.getMessage());
        }
        this.logger.debug("accessToken: {}", (Object)accessToken);
        oAuth10Credentials.setAccessToken(accessToken);
    }
}

