/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client;

import org.pac4j.cas.authorization.DefaultCasAuthorizationGenerator;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.credentials.authenticator.CasAuthenticator;
import org.pac4j.cas.credentials.extractor.TicketAndLogoutRequestExtractor;
import org.pac4j.cas.redirect.CasRedirectionActionBuilder;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.QueryParameterCallbackUrlResolver;
import org.pac4j.core.logout.CasLogoutActionBuilder;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.util.CommonHelper;

public class CasClient
extends IndirectClient<TokenCredentials> {
    private CasConfiguration configuration = new CasConfiguration();

    public CasClient() {
    }

    public CasClient(CasConfiguration configuration) {
        this.setConfiguration(configuration);
    }

    protected void clientInit() {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.setUrlResolver(this.getUrlResolver());
        this.defaultRedirectionActionBuilder(new CasRedirectionActionBuilder(this.configuration, this));
        this.defaultCredentialsExtractor(new TicketAndLogoutRequestExtractor(this.configuration));
        this.defaultAuthenticator(new CasAuthenticator(this.configuration, this.getName(), this.getUrlResolver(), this.getCallbackUrlResolver(), this.callbackUrl));
        this.defaultLogoutActionBuilder((LogoutActionBuilder)new CasLogoutActionBuilder(this.configuration.computeFinalPrefixUrl(null) + "logout", this.configuration.getPostLogoutUrlParameter()));
        this.addAuthorizationGenerator(new DefaultCasAuthorizationGenerator());
    }

    protected CallbackUrlResolver newDefaultCallbackUrlResolver() {
        return new QueryParameterCallbackUrlResolver(this.configuration.getCustomParams());
    }

    public void notifySessionRenewal(String oldSessionId, WebContext context) {
        this.configuration.findLogoutHandler().renewSession(oldSessionId, context);
    }

    public CasConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CasConfiguration configuration) {
        this.configuration = configuration;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "callbackUrl", this.callbackUrl, "callbackUrlResolver", this.callbackUrlResolver, "ajaxRequestResolver", this.getAjaxRequestResolver(), "redirectionActionBuilder", this.getRedirectionActionBuilder(), "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "logoutActionBuilder", this.getLogoutActionBuilder(), "authorizationGenerators", this.getAuthorizationGenerators(), "configuration", this.configuration, "urlResolver", this.urlResolver});
    }
}

