/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.model.DescriptorConfiguration;
import org.apache.knox.gateway.model.ProviderConfiguration;
import org.apache.knox.gateway.model.Topology;
import org.xml.sax.SAXException;

public class TopologyToDescriptor {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String SCHEMA_FILE = "/conf/topology-v1.xsd";
    private String topologyPath;
    private String providerName;
    private String descriptorName;
    private String discoveryUrl;
    private String discoveryUser;
    private String discoveryPasswordAlias;
    private String discoveryType;
    private String cluster;
    private String providerConfigDir;
    private String descriptorConfigDir;
    private boolean force;

    private void validateTopology(String xsd, String topologyFile) throws IOException, SAXException {
        try (InputStream topologyFileStream = Files.newInputStream(Paths.get(topologyFile, new String[0]), new OpenOption[0]);){
            StreamSource xmlSource = new StreamSource(topologyFileStream);
            Schema schema = this.getSchema(xsd);
            Validator validator = schema.newValidator();
            validator.validate(xmlSource);
        }
        catch (IOException | SAXException e) {
            LOG.errorValidatingTopology(topologyFile);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Topology parseTopology(String xsd, String topologyFile) throws JAXBException, SAXException, IOException {
        try (InputStream topologyFileStream = Files.newInputStream(Paths.get(topologyFile, new String[0]), new OpenOption[0]);){
            Schema schema = this.getSchema(xsd);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Topology.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setSchema(schema);
            Topology topology = (Topology)unmarshaller.unmarshal(topologyFileStream);
            return topology;
        }
        catch (IOException | JAXBException | SAXException e) {
            LOG.errorParsingTopology(topologyFile);
            throw e;
        }
    }

    private Schema getSchema(String xsd) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL schemaUrl = TopologyToDescriptor.class.getResource(xsd);
        return schemaFactory.newSchema(schemaUrl);
    }

    public void validate() throws IOException, SAXException {
        this.validateTopology(SCHEMA_FILE, this.topologyPath);
    }

    public void convert() throws IOException, JAXBException, SAXException {
        Topology topology = this.parseTopology(SCHEMA_FILE, this.topologyPath);
        this.saveProvider(topology);
        this.saveDescriptor(topology, this.providerName);
    }

    private void saveProvider(Topology topology) throws IOException {
        try {
            ProviderConfiguration provider = new ProviderConfiguration();
            if (topology.getProviders() != null) {
                provider.setProviders(topology.getProviders());
            }
            File providerFile = new File(this.providerConfigDir + File.separator + this.providerName);
            this.fileCheck(providerFile);
            mapper.writerWithDefaultPrettyPrinter().writeValue(providerFile, (Object)provider);
        }
        catch (IOException e) {
            LOG.errorSavingProviderConfiguration(this.providerName, this.topologyPath, e.toString());
            throw e;
        }
    }

    private void saveDescriptor(Topology topology, String providerName) throws IOException {
        DescriptorConfiguration descriptorConfiguration = new DescriptorConfiguration();
        descriptorConfiguration.setProviderConfig(FilenameUtils.removeExtension((String)providerName));
        if (!StringUtils.isBlank((CharSequence)this.discoveryUrl)) {
            descriptorConfiguration.setDiscoveryAddress(this.discoveryUrl);
        }
        if (!StringUtils.isBlank((CharSequence)this.discoveryUser)) {
            descriptorConfiguration.setDiscoveryUser(this.discoveryUser);
        }
        if (!StringUtils.isBlank((CharSequence)this.discoveryPasswordAlias)) {
            descriptorConfiguration.setDiscoveryPasswordAlias(this.discoveryPasswordAlias);
        }
        if (!StringUtils.isBlank((CharSequence)this.discoveryType)) {
            descriptorConfiguration.setDiscoveryType(this.discoveryType);
        }
        if (!StringUtils.isBlank((CharSequence)this.cluster)) {
            descriptorConfiguration.setCluster(this.cluster);
        }
        if (topology.getName() != null) {
            descriptorConfiguration.setName(topology.getName());
        }
        if (topology.getApplications() != null) {
            descriptorConfiguration.setApplications(topology.getApplications());
        }
        if (topology.getServices() != null) {
            descriptorConfiguration.setServices(topology.getServices());
        }
        File descriptorFile = new File(this.descriptorConfigDir + File.separator + this.descriptorName);
        this.fileCheck(descriptorFile);
        try {
            mapper.writerWithDefaultPrettyPrinter().writeValue(descriptorFile, (Object)descriptorConfiguration);
        }
        catch (IOException e) {
            LOG.errorSavingDescriptorConfiguration(this.descriptorName, this.topologyPath, e.toString());
            throw e;
        }
    }

    private void fileCheck(File file) throws IOException {
        if (!this.force && file.exists()) {
            throw new IOException(String.format(Locale.ROOT, "File %s already exist, use --force option to overwrite.", file.getAbsolutePath()));
        }
        if (!file.getParentFile().exists()) {
            Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
        }
        file.createNewFile();
    }

    public void setDiscoveryUrl(String discoveryUrl) {
        this.discoveryUrl = discoveryUrl;
    }

    public void setDiscoveryUser(String discoveryUser) {
        this.discoveryUser = discoveryUser;
    }

    public void setDiscoveryPasswordAlias(String discoveryPasswordAlias) {
        this.discoveryPasswordAlias = discoveryPasswordAlias;
    }

    public void setDiscoveryType(String discoveryType) {
        this.discoveryType = discoveryType;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public void setTopologyPath(String topologyPath) {
        this.topologyPath = topologyPath;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public void setDescriptorName(String descriptorName) {
        this.descriptorName = descriptorName;
    }

    public void setProviderConfigDir(String providerConfigDir) {
        this.providerConfigDir = providerConfigDir;
    }

    public void setDescriptorConfigDir(String descriptorConfigDir) {
        this.descriptorConfigDir = descriptorConfigDir;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

