/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.search.Filter;
import org.apache.directory.api.util.Strings;

public class SubstringFilter
extends Filter {
    private String type;
    private int substringsLength;
    private String initialSubstrings;
    private List<String> anySubstrings = new ArrayList<String>(1);
    private String finalSubstrings;
    private int substringsFilterLength;
    private int substringsFilterSequenceLength;

    public SubstringFilter(int tlvId) {
        super(tlvId);
    }

    public SubstringFilter() {
    }

    public List<String> getAnySubstrings() {
        return this.anySubstrings;
    }

    public void addAnySubstrings(String any) {
        this.anySubstrings.add(any);
    }

    public String getFinalSubstrings() {
        return this.finalSubstrings;
    }

    public void setFinalSubstrings(String finalSubstrings) {
        this.finalSubstrings = finalSubstrings;
    }

    public String getInitialSubstrings() {
        return this.initialSubstrings;
    }

    public void setInitialSubstrings(String initialSubstrings) {
        this.initialSubstrings = initialSubstrings;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getSubstringsLength() {
        return this.substringsLength;
    }

    public void setSubstringsLength(int substringsLength) {
        this.substringsLength = substringsLength;
    }

    @Override
    public int computeLength() {
        int typeLength = Strings.getBytesUtf8((String)this.type).length;
        this.substringsFilterLength = 1 + TLV.getNbBytes((int)typeLength) + typeLength;
        this.substringsFilterSequenceLength = 0;
        if (this.initialSubstrings != null) {
            int initialLength = Strings.getBytesUtf8((String)this.initialSubstrings).length;
            this.substringsFilterSequenceLength += 1 + TLV.getNbBytes((int)initialLength) + initialLength;
        }
        if (this.anySubstrings != null) {
            for (String any : this.anySubstrings) {
                int anyLength = Strings.getBytesUtf8((String)any).length;
                this.substringsFilterSequenceLength += 1 + TLV.getNbBytes((int)anyLength) + anyLength;
            }
        }
        if (this.finalSubstrings != null) {
            int finalLength = Strings.getBytesUtf8((String)this.finalSubstrings).length;
            this.substringsFilterSequenceLength += 1 + TLV.getNbBytes((int)finalLength) + finalLength;
        }
        this.substringsFilterLength += 1 + TLV.getNbBytes((int)this.substringsFilterSequenceLength) + this.substringsFilterSequenceLength;
        return 1 + TLV.getNbBytes((int)this.substringsFilterLength) + this.substringsFilterLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_08000_CANNOT_PUT_A_PDU_IN_NULL_BUFFER, (Object[])new Object[0]));
        }
        try {
            Object initialBytes;
            buffer.put((byte)-92);
            buffer.put(TLV.getBytes((int)this.substringsFilterLength));
            BerValue.encode((ByteBuffer)buffer, (byte[])Strings.getBytesUtf8((String)this.type));
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes((int)this.substringsFilterSequenceLength));
            if (this.initialSubstrings == null && (this.anySubstrings == null || this.anySubstrings.isEmpty()) && this.finalSubstrings == null) {
                throw new EncoderException(I18n.err((I18n)I18n.ERR_05502_NULL_INITIAL_ANY_OR_FINAL_SUBSTRING, (Object[])new Object[0]));
            }
            if (this.initialSubstrings != null) {
                initialBytes = Strings.getBytesUtf8((String)this.initialSubstrings);
                buffer.put((byte)-128);
                buffer.put(TLV.getBytes((int)((Object)initialBytes).length));
                buffer.put((byte[])initialBytes);
            }
            if (this.anySubstrings != null) {
                initialBytes = this.anySubstrings.iterator();
                while (initialBytes.hasNext()) {
                    String any = (String)initialBytes.next();
                    byte[] anyBytes = Strings.getBytesUtf8((String)any);
                    buffer.put((byte)-127);
                    buffer.put(TLV.getBytes((int)anyBytes.length));
                    buffer.put(anyBytes);
                }
            }
            if (this.finalSubstrings != null) {
                byte[] finalBytes = Strings.getBytesUtf8((String)this.finalSubstrings);
                buffer.put((byte)-126);
                buffer.put(TLV.getBytes((int)finalBytes.length));
                buffer.put(finalBytes);
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_08212_PDU_BUFFER_TOO_SMALL, (Object[])new Object[0]), (Exception)boe);
        }
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.initialSubstrings != null) {
            sb.append(this.initialSubstrings);
        }
        sb.append('*');
        if (this.anySubstrings != null) {
            for (String any : this.anySubstrings) {
                sb.append(any).append('*');
            }
        }
        if (this.finalSubstrings != null) {
            sb.append(this.finalSubstrings);
        }
        return sb.toString();
    }
}

