/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import org.apache.kylin.common.KylinVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KylinVersionTest {
    @Test
    public void testNormal() {
        KylinVersion ver1 = new KylinVersion("2.1.0");
        Assertions.assertEquals((int)2, (int)ver1.major);
        Assertions.assertEquals((int)1, (int)ver1.minor);
        Assertions.assertEquals((int)0, (int)ver1.revision);
    }

    @Test
    void testNoRevision() {
        KylinVersion ver1 = new KylinVersion("2.1");
        Assertions.assertEquals((int)2, (int)ver1.major);
        Assertions.assertEquals((int)1, (int)ver1.minor);
        Assertions.assertEquals((int)0, (int)ver1.revision);
    }

    @Test
    void testToString() {
        KylinVersion ver1 = new KylinVersion("2.1.7.321");
        Assertions.assertEquals((int)2, (int)ver1.major);
        Assertions.assertEquals((int)1, (int)ver1.minor);
        Assertions.assertEquals((int)7, (int)ver1.revision);
        Assertions.assertEquals((int)321, (int)ver1.internal);
        Assertions.assertEquals((Object)"2.1.7.321", (Object)ver1.toString());
    }

    @Test
    void testCompare() {
        Assertions.assertTrue((boolean)KylinVersion.isBefore200((String)"1.9.9"));
        Assertions.assertFalse((boolean)KylinVersion.isBefore200((String)"2.0.0"));
        Assertions.assertTrue((new KylinVersion("2.1.0").compareTo((Object)new KylinVersion("2.1.0.123")) < 0 ? 1 : 0) != 0);
    }
}

