/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.util.NavigableSet;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.InMemResourceStore;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.ResourceStoreTestBase;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.persistence.TransparentResourceStore;
import org.apache.kylin.common.persistence.VersionConflictException;
import org.apache.kylin.common.persistence.transaction.TransactionException;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@MetadataInfo(onlyProps=true)
class TransparentResourceStoreTest {
    String dir1 = "INDEX_PLAN";
    String dir2 = "TABLE_INFO";
    String dirXyz = "PROJECT";
    String path1 = "INDEX_PLAN/_test.json";
    String path2 = "TABLE_INFO/_test.json";
    String path3 = "TABLE_INFO/_test2.json";
    String pathXyz = this.dirXyz + "/xyz";
    String pathCubeX = "INDEX_PLAN/cubex";

    TransparentResourceStoreTest() {
    }

    private ResourceStore getStore() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        ResourceStore underlying = ResourceStore.getKylinMetaStore((KylinConfig)config);
        return new TransparentResourceStore((InMemResourceStore)underlying, config);
    }

    @Test
    void testRecreateMetadataInOneTransaction() {
        String dir = "/default/table_desc/TEST_KYLIN_FACT.json";
        StringEntity table = new StringEntity("TEST_KYLIN_FACT");
        Assertions.assertThrows(TransactionException.class, () -> UnitOfWork.doInTransactionWithRetry(() -> {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            config.setProperty("kylin.env", "DEV");
            ResourceStore underlying = ResourceStore.getKylinMetaStore((KylinConfig)config);
            underlying.deleteResource(dir);
            underlying.checkAndPutResource(dir, (RootPersistentEntity)table, StringEntity.serializer);
            config.setProperty("kylin.env", "UT");
            return 0;
        }, (String)"default"));
    }

    @Test
    void testOverlay() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        ResourceStore underlying = ResourceStore.getKylinMetaStore((KylinConfig)config);
        underlying.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity("UUID", RandomUtil.randomUUIDStr()), StringEntity.serializer);
        this.doInit(underlying);
        ResourceStore rs = underlying;
        this.checkInitResult(rs);
        StringEntity old_se_2 = (StringEntity)rs.getResource(this.path2, StringEntity.serializer);
        rs.deleteResource(this.path2);
        this.checkDeleteResult(rs);
        rs.deleteResource(this.path2);
        Assertions.assertFalse((boolean)rs.exists(this.path2));
        try {
            rs.checkAndPutResource(this.path2, (RootPersistentEntity)old_se_2, StringEntity.serializer);
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        StringEntity new_se_2 = new StringEntity("new_2");
        rs.checkAndPutResource(this.path2, (RootPersistentEntity)new_se_2, StringEntity.serializer);
        this.checkCreateResult(rs);
        rs.deleteResource(this.path2);
        this.checkDeleteResult(rs);
        rs.deleteResource(this.path3);
        this.checkDeletePath3Result(rs);
        rs.deleteResource(this.path1);
        this.checkDeletePath1Result(rs);
        rs.deleteResource(this.pathXyz);
        this.checkDeletePathXyzResult(rs);
        StringEntity se1 = new StringEntity("se1");
        StringEntity se2 = new StringEntity("se2");
        rs.checkAndPutResource("MODEL/b", (RootPersistentEntity)se1, StringEntity.serializer);
        rs.checkAndPutResource("MODEL/z", (RootPersistentEntity)se2, StringEntity.serializer);
        this.checkAddResult(rs);
        StringEntity cubex = (StringEntity)rs.getResource(this.pathCubeX, StringEntity.serializer);
        cubex.setStr("cubex2");
        rs.checkAndPutResource(this.pathCubeX, (RootPersistentEntity)cubex, StringEntity.serializer);
        StringEntity se2_old = (StringEntity)rs.getResource("MODEL/z", StringEntity.serializer);
        Assertions.assertEquals((long)0L, (long)se2_old.getMvcc());
        se2_old.setStr("abccc");
        rs.checkAndPutResource("MODEL/z", (RootPersistentEntity)se2_old, StringEntity.serializer);
        StringEntity se2_new = (StringEntity)rs.getResource("MODEL/z", StringEntity.serializer);
        Assertions.assertEquals((long)1L, (long)se2_old.getMvcc());
        Assertions.assertEquals((long)1L, (long)se2_new.getMvcc());
        Assertions.assertEquals((Object)"abccc", (Object)se2_new.getStr());
        se2_new.setStr("abccc2");
        se2_new.setMvcc(0L);
        try {
            rs.checkAndPutResource("MODEL/z", (RootPersistentEntity)se2_new, StringEntity.serializer);
            Assert.fail();
        }
        catch (VersionConflictException versionConflictException) {
            // empty catch block
        }
        this.checkMvcc(rs);
    }

    void doInit(ResourceStore underlying) {
        StringEntity content1 = new StringEntity("1");
        StringEntity content2 = new StringEntity("2");
        StringEntity content3 = new StringEntity("3");
        StringEntity contentxyz = new StringEntity("xyz");
        StringEntity contentcubex = new StringEntity("cubex");
        underlying.deleteResource(this.path1);
        underlying.deleteResource(this.path2);
        underlying.deleteResource(this.path3);
        underlying.deleteResource(this.pathXyz);
        underlying.deleteResource(this.pathCubeX);
        underlying.checkAndPutResource(this.path1, (RootPersistentEntity)content1, StringEntity.serializer);
        underlying.checkAndPutResource(this.path2, (RootPersistentEntity)content2, StringEntity.serializer);
        underlying.checkAndPutResource(this.path3, (RootPersistentEntity)content3, StringEntity.serializer);
        underlying.checkAndPutResource(this.pathXyz, (RootPersistentEntity)contentxyz, StringEntity.serializer);
        underlying.checkAndPutResource(this.pathCubeX, (RootPersistentEntity)contentcubex, StringEntity.serializer);
    }

    void checkInitResult(ResourceStore rs) {
        NavigableSet list1 = rs.listResourcesRecursively(MetadataType.ALL.name());
        Assertions.assertEquals((int)6, (int)list1.size());
        Assertions.assertTrue((boolean)list1.containsAll(Sets.newHashSet((Object[])new String[]{this.path1, this.path2, this.path3, ResourceStore.METASTORE_UUID_TAG, this.pathXyz, this.pathCubeX})));
        NavigableSet list2 = rs.listResources(MetadataType.ALL.name());
        Assertions.assertEquals((int)31, (int)list2.size());
        Assertions.assertTrue((boolean)list2.containsAll(Sets.newHashSet((Object[])new String[]{this.dir1, this.dir2, MetadataType.SYSTEM.name(), this.dirXyz})));
        Assertions.assertTrue((boolean)rs.exists(this.path1));
        Assertions.assertTrue((boolean)rs.exists(this.path2));
        Assertions.assertTrue((boolean)rs.exists(this.path3));
        Assertions.assertTrue((boolean)rs.exists(this.pathXyz));
        Assertions.assertTrue((boolean)rs.exists(this.pathCubeX));
    }

    void checkDeleteResult(ResourceStore rs) {
        NavigableSet list1 = rs.listResourcesRecursively(MetadataType.ALL.name());
        Assertions.assertEquals((int)5, (int)list1.size());
        Assertions.assertTrue((boolean)list1.containsAll(Sets.newHashSet((Object[])new String[]{this.path1, this.path3, ResourceStore.METASTORE_UUID_TAG, this.pathXyz, this.pathCubeX})));
        NavigableSet list2 = rs.listResources(MetadataType.ALL.name());
        Assertions.assertEquals((int)31, (int)list2.size());
        Assertions.assertTrue((boolean)list2.containsAll(Sets.newHashSet((Object[])new String[]{this.dir1, this.dir2, MetadataType.SYSTEM.name(), this.dirXyz})));
        Assertions.assertTrue((boolean)rs.exists(this.path1));
        Assertions.assertFalse((boolean)rs.exists(this.path2));
        Assertions.assertTrue((boolean)rs.exists(this.path3));
        Assertions.assertTrue((boolean)rs.exists(this.pathXyz));
        Assertions.assertTrue((boolean)rs.exists(this.pathCubeX));
    }

    void checkCreateResult(ResourceStore rs) {
        NavigableSet list1 = rs.listResourcesRecursively(MetadataType.ALL.name());
        Assertions.assertEquals((int)6, (int)list1.size());
        Assertions.assertTrue((boolean)list1.containsAll(Sets.newHashSet((Object[])new String[]{this.path1, this.path2, this.path3, ResourceStore.METASTORE_UUID_TAG, this.pathXyz, this.pathCubeX})));
        NavigableSet list2 = rs.listResources(MetadataType.ALL.name());
        Assertions.assertEquals((int)31, (int)list2.size());
        Assertions.assertTrue((boolean)list2.containsAll(Sets.newHashSet((Object[])new String[]{this.dir1, this.dir2, MetadataType.SYSTEM.name(), this.dirXyz})));
        Assertions.assertTrue((boolean)rs.exists(this.path1));
        Assertions.assertTrue((boolean)rs.exists(this.path2));
        Assertions.assertTrue((boolean)rs.exists(this.path3));
        Assertions.assertTrue((boolean)rs.exists(this.pathXyz));
        Assertions.assertTrue((boolean)rs.exists(this.pathCubeX));
    }

    void checkDeletePath3Result(ResourceStore rs) {
        NavigableSet list1 = rs.listResourcesRecursively(MetadataType.ALL.name());
        Assertions.assertEquals((int)4, (int)list1.size());
        Assertions.assertTrue((boolean)list1.containsAll(Sets.newHashSet((Object[])new String[]{this.path1, ResourceStore.METASTORE_UUID_TAG, this.pathXyz, this.pathCubeX})));
        NavigableSet list2 = rs.listResources(MetadataType.ALL.name());
        Assertions.assertEquals((int)31, (int)list2.size());
        Assertions.assertTrue((boolean)list2.containsAll(Sets.newHashSet((Object[])new String[]{this.dir1, MetadataType.SYSTEM.name(), this.dirXyz})));
        Assertions.assertTrue((boolean)rs.exists(this.path1));
        Assertions.assertFalse((boolean)rs.exists(this.path2));
        Assertions.assertFalse((boolean)rs.exists(this.path3));
        Assertions.assertTrue((boolean)rs.exists(this.pathXyz));
        Assertions.assertTrue((boolean)rs.exists(this.pathCubeX));
    }

    void checkDeletePath1Result(ResourceStore rs) {
        NavigableSet list1 = rs.listResourcesRecursively(MetadataType.ALL.name());
        Assertions.assertEquals((int)3, (int)list1.size());
        Assertions.assertTrue((boolean)list1.containsAll(Sets.newHashSet((Object[])new String[]{ResourceStore.METASTORE_UUID_TAG, this.pathXyz, this.pathCubeX})));
        NavigableSet list2 = rs.listResources(MetadataType.ALL.name());
        Assertions.assertEquals((int)31, (int)list2.size());
        Assertions.assertTrue((boolean)list2.containsAll(Sets.newHashSet((Object[])new String[]{MetadataType.SYSTEM.name(), this.dirXyz})));
        Assertions.assertFalse((boolean)rs.exists(this.path1));
        Assertions.assertFalse((boolean)rs.exists(this.path2));
        Assertions.assertFalse((boolean)rs.exists(this.path3));
        Assertions.assertTrue((boolean)rs.exists(this.pathXyz));
        Assertions.assertTrue((boolean)rs.exists(this.pathCubeX));
    }

    void checkDeletePathXyzResult(ResourceStore rs) {
        NavigableSet list1 = rs.listResourcesRecursively(MetadataType.ALL.name());
        Assertions.assertEquals((int)2, (int)list1.size());
        Assertions.assertTrue((boolean)list1.containsAll(Sets.newHashSet((Object[])new String[]{ResourceStore.METASTORE_UUID_TAG, this.pathCubeX})));
        NavigableSet list2 = rs.listResources(MetadataType.ALL.name());
        Assertions.assertEquals((int)31, (int)list2.size());
        Assertions.assertTrue((boolean)list2.containsAll(Sets.newHashSet((Object[])new String[]{MetadataType.SYSTEM.name(), this.dirXyz})));
        Assertions.assertFalse((boolean)rs.exists(this.path1));
        Assertions.assertFalse((boolean)rs.exists(this.path2));
        Assertions.assertFalse((boolean)rs.exists(this.path3));
        Assertions.assertFalse((boolean)rs.exists(this.pathXyz));
        Assertions.assertTrue((boolean)rs.exists(this.pathCubeX));
    }

    void checkAddResult(ResourceStore rs) {
        NavigableSet list1 = rs.listResourcesRecursively(MetadataType.ALL.name());
        Assertions.assertEquals((int)4, (int)list1.size());
        Assertions.assertTrue((boolean)list1.containsAll(Sets.newHashSet((Object[])new String[]{ResourceStore.METASTORE_UUID_TAG, this.pathCubeX, "MODEL/b", "MODEL/z"})));
        NavigableSet list2 = rs.listResources(MetadataType.ALL.name());
        Assertions.assertEquals((int)31, (int)list2.size());
        Assertions.assertTrue((boolean)list2.containsAll(Sets.newHashSet((Object[])new String[]{this.dir1, MetadataType.SYSTEM.name(), "MODEL"})));
        Assertions.assertFalse((boolean)rs.exists(this.path1));
        Assertions.assertFalse((boolean)rs.exists(this.path2));
        Assertions.assertFalse((boolean)rs.exists(this.path3));
        Assertions.assertFalse((boolean)rs.exists(this.pathXyz));
        Assertions.assertTrue((boolean)rs.exists(this.pathCubeX));
        Assertions.assertTrue((boolean)rs.exists("MODEL/b"));
        Assertions.assertTrue((boolean)rs.exists("MODEL/z"));
    }

    void checkMvcc(ResourceStore rs) {
        Assertions.assertEquals((int)4, (int)rs.listResourcesRecursively(MetadataType.ALL.name()).size());
        Assertions.assertEquals((long)1L, (long)((StringEntity)rs.getResource(this.pathCubeX, StringEntity.serializer)).getMvcc());
        Assertions.assertEquals((long)0L, (long)((StringEntity)rs.getResource("MODEL/b", StringEntity.serializer)).getMvcc());
        Assertions.assertEquals((long)1L, (long)((StringEntity)rs.getResource("MODEL/z", StringEntity.serializer)).getMvcc());
        Assertions.assertEquals((long)0L, (long)((StringEntity)rs.getResource(ResourceStore.METASTORE_UUID_TAG, StringEntity.serializer)).getMvcc());
    }

    @Test
    void testAStore() {
        ResourceStoreTestBase.testAStore(this.getStore());
    }

    @Test
    void testUUID() {
        ResourceStoreTestBase.testGetUUID(this.getStore());
    }
}

