/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.InMemResourceStore;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.UnitMessages;
import org.apache.kylin.common.persistence.event.ResourceCreateOrUpdateEvent;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.JdbcMetadataStore;
import org.apache.kylin.common.persistence.metadata.MetadataMapperFactory;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.persistence.metadata.mapper.ProjectMapper;
import org.apache.kylin.common.persistence.metadata.mapper.TableInfoMapper;
import org.apache.kylin.common.persistence.resources.ModelRawResource;
import org.apache.kylin.common.persistence.resources.ProjectRawResource;
import org.apache.kylin.common.persistence.resources.TableInfoRawResource;
import org.apache.kylin.common.persistence.transaction.TransactionException;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.CompressionUtils;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.apache.kylin.junit.annotation.JdbcMetadataInfo;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.apache.kylin.junit.annotation.OverwriteProp;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mybatis.dynamic.sql.select.SelectDSLCompleter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.transaction.IllegalTransactionStateException;

@MetadataInfo(onlyProps=true)
@JdbcMetadataInfo
class JdbcMetadataStoreTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcMetadataStoreTest.class);
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    ProjectRawResource prj0;
    DataSource dataSource;
    JdbcTemplate jdbcTemplate;

    JdbcMetadataStoreTest() {
    }

    @BeforeEach
    public void setup() throws Exception {
        this.prj0 = new ProjectRawResource();
        this.prj0.setMetaKey("prj0");
        this.prj0.setName("p0");
        this.prj0.setUuid(UUID.randomUUID().toString());
        this.prj0.setContent("{\"name\" : \"p0\"}".getBytes(DEFAULT_CHARSET));
        this.prj0.setTs(Long.valueOf(System.currentTimeMillis()));
        this.prj0.setMvcc(0L);
        this.dataSource = JdbcDataSource.getDataSource((Properties)JdbcUtil.datasourceParameters((StorageURL)this.getTestConfig().getMetadataUrl()));
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
    }

    @Test
    void testBasic() throws Exception {
        String uuid2 = UUID.randomUUID().toString();
        byte[] bytes2 = ("{ \"uuid\" : \"" + uuid2 + "\",\"meta_key\" : \"db.abc2\",\"name\" : \"abc2\", \"project\" : \"pj1\"}").getBytes(DEFAULT_CHARSET);
        UnitOfWork.doInTransactionWithRetry(() -> {
            UnitOfWork.get().getCopyForWriteItems().add("TABLE_INFO/db.abc");
            UnitOfWork.get().getCopyForWriteItems().add("TABLE_INFO/db.abc2");
            UnitOfWork.get().getCopyForWriteItems().add("TABLE_INFO/db.abc3");
            UnitOfWork.get().getCopyForWriteItems().add("TABLE_INFO/db.abc4");
            ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            store.checkAndPutResource("TABLE_INFO/db.abc", ByteSource.wrap((byte[])"{ \"uuid\" : \"ffffffff-ffff-ffff-ffff-ffffffffffff\",\"meta_key\" : \"db.abc\",\"name\" : \"abc\", \"project\" : \"pj1\"}".getBytes(DEFAULT_CHARSET)), -1L);
            RawResource rawResource = store.checkAndPutResource("TABLE_INFO/db.abc2", ByteSource.wrap((byte[])bytes2), -1L);
            Assertions.assertEquals((Object)uuid2, (Object)rawResource.getUuid());
            Assertions.assertEquals((Object)"pj1", (Object)rawResource.getProject());
            Assertions.assertEquals((Object)"db.abc2", (Object)rawResource.getMetaKey());
            String uuid = UUID.randomUUID().toString();
            store.checkAndPutResource("TABLE_INFO/db.abc3", ByteSource.wrap((byte[])("{ \"uuid\" : \"" + uuid + "\",\"meta_key\" : \"db.abc3\",\"name\" : \"abc3\", \"project\" : \"pj1\"}").getBytes(DEFAULT_CHARSET)), -1L);
            store.checkAndPutResource("TABLE_INFO/db.abc3", ByteSource.wrap((byte[])("{ \"uuid\" : \"" + uuid + "\",\"meta_key\" : \"db.abc3\",\"name\" : \"abc3\", \"project\" : \"pj1\"}").getBytes(DEFAULT_CHARSET)), 0L);
            uuid = UUID.randomUUID().toString();
            store.checkAndPutResource("TABLE_INFO/db.abc4", ByteSource.wrap((byte[])("{ \"uuid\" : \"" + uuid + "\",\"meta_key\" : \"db.abc4\",\"name\" : \"abc4\", \"project\" : \"pj1\"}").getBytes(DEFAULT_CHARSET)), 1000L, -1L);
            store.deleteResource("TABLE_INFO/db.abc");
            return 0;
        }, (String)"_global");
        try {
            SqlSessionFactory sqlSessionFactory = MetadataMapperFactory.getSqlSessionFactory((DataSource)this.dataSource);
            try (SqlSession session = sqlSessionFactory.openSession();){
                TableInfoMapper mapper = (TableInfoMapper)session.getMapper(TableInfoMapper.class);
                List all = mapper.select(SelectDSLCompleter.allRows());
                Assertions.assertEquals((int)3, (int)all.size());
                for (TableInfoRawResource resource : all) {
                    if (resource.getMetaKey().equals("_global")) {
                        Assertions.assertEquals((long)0L, (long)resource.getMvcc());
                        Assertions.assertArrayEquals((byte[])bytes2, (byte[])resource.getContent());
                    }
                    if (resource.getMetaKey().equals("db.abc3")) {
                        Assertions.assertEquals((long)1L, (long)resource.getMvcc());
                    }
                    if (!resource.getMetaKey().equals("db.abc4")) continue;
                    Assertions.assertEquals((long)1000L, (Long)resource.getTs());
                }
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    void testReload() throws Exception {
        UnitOfWork.doInTransactionWithRetry(() -> {
            UnitOfWork.get().getCopyForWriteItems().add("TABLE_INFO/db.abc2");
            String uuid = UUID.randomUUID().toString();
            ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            store.checkAndPutResource("TABLE_INFO/db.abc2", ByteSource.wrap((byte[])("{ \"uuid\" : \"" + uuid + "\",\"meta_key\" : \"db.abc2\",\"name\" : \"abc2\", \"project\" : \"pj1\"}").getBytes(DEFAULT_CHARSET)), -1L);
            return 0;
        }, (String)"_global");
        try {
            SqlSessionFactory sqlSessionFactory = MetadataMapperFactory.getSqlSessionFactory((DataSource)this.dataSource);
            try (SqlSession session = sqlSessionFactory.openSession();){
                TableInfoMapper mapper = (TableInfoMapper)session.getMapper(TableInfoMapper.class);
                List all = mapper.select(SelectDSLCompleter.allRows());
                Assertions.assertEquals((int)1, (int)all.size());
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException(e);
        }
        ResourceStore systemStore = ResourceStore.getKylinMetaStore((KylinConfig)this.getTestConfig());
        systemStore.reload();
        int size = systemStore.listResourcesRecursively(MetadataType.TABLE_INFO.name()).size();
        Assertions.assertEquals((int)1, (int)size);
    }

    @Test
    void testBatchInsert() throws Exception {
        ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
        SqlSessionFactory sqlSessionFactory = MetadataMapperFactory.getSqlSessionFactory((DataSource)this.dataSource);
        try (SqlSession session = sqlSessionFactory.openSession();){
            ProjectMapper mapper = (ProjectMapper)session.getMapper(ProjectMapper.class);
            ProjectRawResource prj1 = new ProjectRawResource();
            prj1.setMetaKey("prj1");
            prj1.setName("_global");
            prj1.setUuid(UUID.randomUUID().toString());
            prj1.setContent("{\"name\" : \"p1\"}".getBytes(DEFAULT_CHARSET));
            prj1.setTs(Long.valueOf(System.currentTimeMillis()));
            prj1.setMvcc(0L);
            int count = mapper.insertMultiple(Arrays.asList(this.prj0, prj1));
            Assertions.assertEquals((int)2, (int)count);
            List collect = IntStream.range(0, 2048).mapToObj(i -> {
                String uuid = UUID.randomUUID().toString();
                ModelRawResource md = new ModelRawResource();
                md.setMetaKey(uuid);
                md.setAlias("m" + i);
                md.setUuid(uuid);
                md.setProject("p" + i / 1024);
                md.setContent(("{\"uuid\" : \"" + uuid + "\",\"alias\" : \"m" + i + "\"}").getBytes(DEFAULT_CHARSET));
                md.setTs(Long.valueOf(System.currentTimeMillis()));
                md.setMvcc(0L);
                return md;
            }).collect(Collectors.toList());
            UnitOfWork.doInTransactionWithRetry(() -> {
                ResourceStore kylinMetaStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
                MetadataStore metadataStore = kylinMetaStore.getMetadataStore();
                log.info("start to batch insert...");
                Date date = new Date();
                collect.forEach(md -> metadataStore.save(md.getMetaType(), (RawResource)md));
                log.info("batch insert cost {} ms", (Object)(System.currentTimeMillis() - date.getTime()));
                return null;
            }, (String)"_global");
        }
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)this.getTestConfig());
        resourceStore.reload();
        Assertions.assertEquals((int)2048, (int)resourceStore.listResourcesRecursively(MetadataType.MODEL.name()).size());
    }

    @Test
    void testMvccConflict() {
        String uuid = UUID.randomUUID().toString();
        String resourcePath = MetadataType.mergeKeyWithType((String)"abc", (MetadataType)MetadataType.PROJECT);
        ByteSource entityBytes = ByteSource.wrap((byte[])("{ \"uuid\" : \"" + uuid + "\",\"name\" : \"abc\"}").getBytes(DEFAULT_CHARSET));
        UnitOfWork.doInTransactionWithRetry(() -> {
            UnitOfWork.get().getCopyForWriteItems().add(resourcePath);
            ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            store.checkAndPutResource(resourcePath, entityBytes, -1L);
            store.checkAndPutResource(resourcePath, entityBytes, 0L);
            return 0;
        }, (String)"_global");
        String identifier = this.getTestConfig().getMetadataUrl().getIdentifier();
        this.jdbcTemplate.update("update " + identifier + "_project set mvcc = 10");
        UnitOfWork.doInTransactionWithRetry(() -> {
            UnitOfWork.get().getCopyForWriteItems().add(resourcePath);
            ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            Assertions.assertThrows(PersistenceException.class, () -> store.checkAndPutResource(resourcePath, entityBytes, 1L));
            return null;
        }, (String)"_global");
    }

    @Test
    void testUpdateTheDeletedResource() {
        MetadataStore metadataStore = MetadataStore.createMetadataStore((KylinConfig)this.getTestConfig());
        ReflectionTestUtils.setField((Object)metadataStore, (String)"isUT", (Object)false);
        ProjectRawResource prj1 = new ProjectRawResource();
        prj1.setMetaKey("prj0");
        prj1.setName("p0");
        prj1.setUuid(UUID.randomUUID().toString());
        prj1.setContent("{\"name\" : \"p0\"}".getBytes(DEFAULT_CHARSET));
        prj1.setTs(Long.valueOf(System.currentTimeMillis()));
        prj1.setMvcc(4L);
        Assertions.assertThrows(TransactionException.class, () -> UnitOfWork.doInTransactionWithRetry(() -> {
            metadataStore.save(MetadataType.PROJECT, (RawResource)prj1);
            return null;
        }, (String)"_global", (int)1));
    }

    @OverwriteProp.OverwriteProps(value={@OverwriteProp(key="kylin.metadata.compress.enabled", value="false"), @OverwriteProp(key="kylin.server.port", value="8081")})
    @Test
    void testBatchUpdateWithMetadataCompressDisable() throws Exception {
        MetadataStore metadataStore = ResourceStore.getKylinMetaStore((KylinConfig)this.getTestConfig()).getMetadataStore();
        ProjectRawResource prj1 = new ProjectRawResource();
        prj1.setMetaKey("prj1");
        prj1.setUuid(UUID.randomUUID().toString());
        prj1.setContent("{\"name\" : \"prj1\"}".getBytes(DEFAULT_CHARSET));
        prj1.setTs(Long.valueOf(System.currentTimeMillis()));
        prj1.setMvcc(-1L);
        System.out.println("prj1 uuid is:" + prj1.getUuid());
        List<ResourceCreateOrUpdateEvent> events = Collections.singletonList(new ResourceCreateOrUpdateEvent(prj1.generateKeyWithType(), (RawResource)prj1));
        UnitMessages unitMessages = new UnitMessages(events);
        UnitOfWork.doInTransactionWithRetry(() -> JdbcMetadataStoreTest.lambda$testBatchUpdateWithMetadataCompressDisable$10(metadataStore, (RawResource)prj1, unitMessages), (String)prj1.getMetaKey());
        RawResourceFilter filter = RawResourceFilter.equalFilter((String)"metaKey", (String)prj1.getMetaKey());
        String content = new String(ByteSource.wrap((byte[])((RawResource)metadataStore.get(MetadataType.PROJECT, filter, true, true).get(0)).getContent()).read());
        Assertions.assertEquals((Object)"{\"name\" : \"prj1\"}", (Object)content);
        ArrayList<String> provideSelections = new ArrayList<String>();
        provideSelections.add("metaKey");
        List list = ((JdbcMetadataStore)metadataStore).get(MetadataType.PROJECT, filter, true, true, provideSelections);
        ProjectRawResource projectRawResource = (ProjectRawResource)list.get(0);
        Assertions.assertNull((Object)projectRawResource.getName());
        Assertions.assertNull((Object)projectRawResource.getTs());
        Assertions.assertEquals((Object)"_global", (Object)projectRawResource.getProject());
        Assertions.assertEquals((Object)"prj1", (Object)projectRawResource.getMetaKey());
        Assertions.assertEquals((Object)"{\"name\" : \"prj1\"}", (Object)new String(ByteSource.wrap((byte[])projectRawResource.getContent()).read()));
        String identifier = this.getTestConfig().getMetadataUrl().getIdentifier();
        byte[] contents = (byte[])this.jdbcTemplate.queryForObject("select content from " + identifier + "_project where meta_key = 'prj1'", (rs, rowNum) -> rs.getBytes(1));
        Assertions.assertFalse((boolean)CompressionUtils.isCompressed((byte[])contents));
        byte[] auditLogContents = (byte[])this.jdbcTemplate.queryForObject("select meta_content from " + identifier + "_audit_log_v2" + " where meta_key = 'PROJECT/prj1'", (rs, rowNum) -> rs.getBytes(1));
        Assertions.assertFalse((boolean)CompressionUtils.isCompressed((byte[])auditLogContents));
    }

    @Test
    void testGetResourceWithoutContent() {
        MetadataStore metadataStore = MetadataStore.createMetadataStore((KylinConfig)this.getTestConfig());
        Assertions.assertInstanceOf(JdbcMetadataStore.class, (Object)metadataStore);
        metadataStore.save(MetadataType.PROJECT, (RawResource)this.prj0);
        List projects = metadataStore.get(MetadataType.PROJECT, RawResourceFilter.equalFilter((String)"name", (String)this.prj0.getName()), false, false);
        Assertions.assertNotNull((Object)this.prj0.getContent());
        Assertions.assertEquals((int)1, (int)projects.size());
        Assertions.assertNull((Object)((ProjectRawResource)projects.get(0)).getContent());
    }

    @Test
    void testDump() throws IOException, ExecutionException, InterruptedException {
        MetadataStore metadataStore = MetadataStore.createMetadataStore((KylinConfig)this.getTestConfig());
        InMemResourceStore rs = new InMemResourceStore(this.getTestConfig());
        RawResourceFilter emptyFilter = new RawResourceFilter();
        metadataStore.dump((ResourceStore)rs);
        Assertions.assertEquals((int)0, (int)metadataStore.get(MetadataType.PROJECT, emptyFilter, false, false).size());
        rs.putResourceWithoutCheck(this.prj0.generateKeyWithType(), this.prj0.getByteSource(), this.prj0.getTs().longValue(), this.prj0.getMvcc());
        metadataStore.dump((ResourceStore)rs);
        Assertions.assertEquals((int)1, (int)metadataStore.get(MetadataType.PROJECT, emptyFilter, false, false).size());
    }

    @Test
    void testUploadFromFile() throws IOException {
        MetadataStore metadataStore = MetadataStore.createMetadataStore((KylinConfig)this.getTestConfig());
        File tmpDir = Files.createTempDirectory("Metadata_", new FileAttribute[0]).toFile();
        File prjFolder = new File(tmpDir, "PROJECT");
        File prjFile = new File(prjFolder, "prj0.json");
        prjFolder.deleteOnExit();
        prjFile.deleteOnExit();
        if (!prjFolder.mkdirs() || !prjFile.createNewFile()) {
            Assertions.fail((String)"can not create file.");
        }
        RawResourceFilter emptyFilter = new RawResourceFilter();
        JsonUtil.writeValue((File)prjFile, (Object)this.prj0);
        Assertions.assertEquals((int)0, (int)metadataStore.get(MetadataType.PROJECT, emptyFilter, false, false).size());
        metadataStore.uploadFromFile(tmpDir);
        Assertions.assertEquals((int)1, (int)metadataStore.get(MetadataType.PROJECT, emptyFilter, false, false).size());
    }

    @Test
    void testDeleteNotExistResource() {
        MetadataStore metadataStore = MetadataStore.createMetadataStore((KylinConfig)this.getTestConfig());
        this.prj0.setContent(null);
        Assertions.assertEquals((int)-1, (int)metadataStore.save(MetadataType.PROJECT, (RawResource)this.prj0));
    }

    @Test
    void testTransactionCheck() throws Exception {
        JdbcMetadataStore ms = (JdbcMetadataStore)ResourceStore.getKylinMetaStore((KylinConfig)this.getTestConfig()).getMetadataStore();
        DataSourceTransactionManager manager = ms.getTransactionManager();
        try {
            JdbcUtil.withTransaction((DataSourceTransactionManager)manager, () -> {
                UnitOfWork.doInTransactionWithRetry(() -> true, (String)"default");
                return true;
            });
            Assertions.fail((String)"Expected an exception");
        }
        catch (Exception e) {
            Assertions.assertInstanceOf(TransactionException.class, (Object)e.getCause());
            Assertions.assertInstanceOf(IllegalTransactionStateException.class, (Object)e.getCause().getCause());
        }
    }

    KylinConfig getTestConfig() {
        return KylinConfig.getInstanceFromEnv();
    }

    private static /* synthetic */ Object lambda$testBatchUpdateWithMetadataCompressDisable$10(MetadataStore metadataStore, RawResource prj1, UnitMessages unitMessages) throws Exception {
        metadataStore.save(prj1.getMetaType(), prj1);
        metadataStore.getAuditLogStore().save(unitMessages);
        return null;
    }
}

