/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.DefaultHostInfoFetcher;
import org.apache.kylin.common.util.TestUtils;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.Rule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.rules.ExpectedException;

@MetadataInfo(onlyProps=true)
class AddressUtilTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final DefaultHostInfoFetcher hostInfoFetcher = new DefaultHostInfoFetcher();

    AddressUtilTest() {
    }

    @Test
    void testGetLocalInstance() {
        String localAddress = AddressUtil.getLocalInstance();
        Assertions.assertTrue((boolean)localAddress.endsWith(TestUtils.getTestConfig().getServerPort()));
    }

    @Test
    void testGetZkLocalInstance() {
        String localHost = AddressUtil.getZkLocalInstance();
        Assertions.assertTrue((boolean)localHost.endsWith(TestUtils.getTestConfig().getServerPort()));
    }

    @Test
    void testConvertHost() {
        String host = AddressUtil.convertHost((String)"localhost:7070");
        Assertions.assertEquals((Object)"127.0.0.1:7070", (Object)host);
        Assertions.assertEquals((Object)"127.0.0.1:7070", (Object)AddressUtil.convertHost((String)"unknown:7070"));
    }

    @Test
    void testGetMockPortAddress() {
        String mockAddr = AddressUtil.getMockPortAddress();
        Assertions.assertTrue((boolean)mockAddr.endsWith(AddressUtil.MAINTAIN_MODE_MOCK_PORT));
    }

    @Test
    void testGetLocalServerInfo() {
        String servInfo = AddressUtil.getLocalServerInfo();
        Assertions.assertTrue((boolean)servInfo.startsWith(this.hostInfoFetcher.getHostname().replaceAll("[^(_a-zA-Z0-9)]", "")));
    }

    @Test
    void testGetLocalHostExactAddress() {
        String old = TestUtils.getTestConfig().getServerIpAddress();
        String mockIp = "192.168.1.101";
        TestUtils.getTestConfig().setProperty("kylin.env.ip-address", "192.168.1.101");
        AddressUtil.clearLocalIpAddressCache();
        String servIp = AddressUtil.getLocalHostExactAddress();
        Assertions.assertEquals((Object)"192.168.1.101", (Object)servIp);
        if (!StringUtils.isEmpty((CharSequence)old)) {
            TestUtils.getTestConfig().setProperty("kylin.env.ip-address", old);
        }
    }

    @Test
    void testCheckHost() {
        AddressUtil.validateHost((String)"127.0.0.1:7070");
        AddressUtil.validateHost((String)"127.0.0.1");
        AddressUtil.validateHost((String)"707");
        AddressUtil.validateHost((String)"");
        this.testCheckHostFail("127.0.0.1:");
        this.testCheckHostFail(":7070");
        this.testCheckHostFail("127.0.0.1:7070>");
    }

    void testCheckHostFail(String host) {
        try {
            AddressUtil.validateHost((String)host);
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertInstanceOf(IllegalArgumentException.class, (Object)e);
            Assertions.assertTrue((boolean)e.getMessage().contains("Url contains disallowed chars, host: "));
        }
    }

    @Test
    void testIsSameHost() {
        Assertions.assertTrue((boolean)AddressUtil.isSameHost((String)this.hostInfoFetcher.getHostname()));
        Assertions.assertFalse((boolean)AddressUtil.isSameHost((String)"unknown"));
    }

    @Test
    void testExtractIpAndPort() {
        Assertions.assertEquals((Object)"example.com:8080", (Object)AddressUtil.extractIpAndPort((String)"http://example.com:8080/path"));
        Assertions.assertEquals((Object)"example.com:443", (Object)AddressUtil.extractIpAndPort((String)"https://example.com:443/path"));
        Assertions.assertEquals((Object)"example.com:-1", (Object)AddressUtil.extractIpAndPort((String)"http://example.com/path"));
        Assertions.assertEquals((Object)"192.168.1.1:9090", (Object)AddressUtil.extractIpAndPort((String)"http://192.168.1.1:9090"));
        Assertions.assertEquals((Object)"localhost:7070", (Object)AddressUtil.extractIpAndPort((String)"http://localhost:7070"));
        Assertions.assertEquals((Object)"example.com:8080", (Object)AddressUtil.extractIpAndPort((String)"http://example.com:8080/path?param=value"));
        Assertions.assertEquals((Object)"example.com:8080", (Object)AddressUtil.extractIpAndPort((String)"http://example.com:8080/path#section"));
        Assertions.assertEquals((Object)"example .com:8080", (Object)AddressUtil.extractIpAndPort((String)"http://example .com:8080/path#section"));
    }

    @Test
    void testExtractIpAndPortMalformedUrl() {
        Assertions.assertThrows(KylinRuntimeException.class, () -> AddressUtil.extractIpAndPort((String)"example.com:8080"));
        Assertions.assertThrows(KylinRuntimeException.class, () -> AddressUtil.extractIpAndPort((String)""));
        Assertions.assertThrows(Exception.class, () -> AddressUtil.extractIpAndPort(null));
        Assertions.assertThrows(KylinRuntimeException.class, () -> AddressUtil.extractIpAndPort((String)"http:example.com:8080"));
        Assertions.assertThrows(KylinRuntimeException.class, () -> AddressUtil.extractIpAndPort((String)"http:/example.com:8080"));
        Assertions.assertThrows(KylinRuntimeException.class, () -> AddressUtil.extractIpAndPort((String)"http://[invalid"));
    }
}

