/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.solaris.KstatUtil;

public class SolarisFileSystem
implements FileSystem {
    private static final long serialVersionUID = 1L;
    private final List<String> pseudofs = Arrays.asList("proc", "devfs", "ctfs", "objfs", "mntfs", "sharefs", "lofs", "autofs");
    private final List<String> tmpfsPaths = Arrays.asList("/system", "/tmp", "/dev/fd");

    private boolean listElementStartsWith(List<String> aList, String charSeq) {
        for (String match : aList) {
            if (!charSeq.equals(match) && !charSeq.startsWith(match + "/")) continue;
            return true;
        }
        return false;
    }

    @Override
    public OSFileStore[] getFileStores() {
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        HashMap<String, Long> inodeFreeMap = new HashMap<String, Long>();
        HashMap<String, Long> inodeTotalMap = new HashMap<String, Long>();
        String key = null;
        String total = null;
        String free = null;
        for (String line : ExecutingCommand.runNative("df -g")) {
            if (line.startsWith("/")) {
                key = ParseUtil.whitespaces.split(line)[0];
                total = null;
                continue;
            }
            if (line.contains("available") && line.contains("total files")) {
                total = ParseUtil.getTextBetweenStrings(line, "available", "total files").trim();
                continue;
            }
            if (!line.contains("free files")) continue;
            free = ParseUtil.getTextBetweenStrings(line, "", "free files").trim();
            if (key == null || total == null) continue;
            inodeFreeMap.put(key, ParseUtil.parseLongOrDefault(free, 0L));
            inodeTotalMap.put(key, ParseUtil.parseLongOrDefault(total, 0L));
            key = null;
        }
        for (String fs : ExecutingCommand.runNative("cat /etc/mnttab")) {
            String[] split = ParseUtil.whitespaces.split(fs);
            if (split.length < 5) continue;
            String volume = split[0];
            String path = split[1];
            String type = split[2];
            if (this.pseudofs.contains(type) || path.equals("/dev") || this.listElementStartsWith(this.tmpfsPaths, path) || volume.startsWith("rpool") && !path.equals("/")) continue;
            String name = path.substring(path.lastIndexOf(47) + 1);
            if (name.isEmpty()) {
                name = volume.substring(volume.lastIndexOf(47) + 1);
            }
            long totalSpace = new File(path).getTotalSpace();
            long usableSpace = new File(path).getUsableSpace();
            String description = volume.startsWith("/dev") || path.equals("/") ? "Local Disk" : (volume.equals("tmpfs") ? "Ram Disk" : (type.startsWith("nfs") || type.equals("cifs") ? "Network Disk" : "Mount Point"));
            OSFileStore osStore = new OSFileStore();
            osStore.setName(name);
            osStore.setVolume(volume);
            osStore.setMount(path);
            osStore.setDescription(description);
            osStore.setType(type);
            osStore.setUUID("");
            osStore.setUsableSpace(usableSpace);
            osStore.setTotalSpace(totalSpace);
            osStore.setFreeInodes(inodeFreeMap.containsKey(path) ? (Long)inodeFreeMap.get(path) : 0L);
            osStore.setTotalInodes(inodeTotalMap.containsKey(path) ? (Long)inodeTotalMap.get(path) : 0L);
            fsList.add(osStore);
        }
        return fsList.toArray(new OSFileStore[fsList.size()]);
    }

    @Override
    public long getOpenFileDescriptors() {
        LibKstat.Kstat ksp = KstatUtil.kstatLookup(null, -1, "file_cache");
        if (ksp != null && KstatUtil.kstatRead(ksp)) {
            return KstatUtil.kstatDataLookupLong(ksp, "buf_inuse");
        }
        return 0L;
    }

    @Override
    public long getMaxFileDescriptors() {
        LibKstat.Kstat ksp = KstatUtil.kstatLookup(null, -1, "file_cache");
        if (ksp != null && KstatUtil.kstatRead(ksp)) {
            return KstatUtil.kstatDataLookupLong(ksp, "buf_max");
        }
        return 0L;
    }
}

