/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.bitmap;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.kylin.common.util.ByteBufferBackedInputStream;
import org.apache.kylin.common.util.ByteBufferOutputStream;
import org.apache.kylin.measure.bitmap.BitmapCounter;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public class RoaringBitmapCounter
implements BitmapCounter,
Serializable {
    private Roaring64NavigableMap bitmap;
    private Long counter;

    public RoaringBitmapCounter() {
        this.bitmap = new Roaring64NavigableMap();
    }

    RoaringBitmapCounter(Roaring64NavigableMap bitmap) {
        this.bitmap = bitmap;
    }

    RoaringBitmapCounter(long counter) {
        this.bitmap = new Roaring64NavigableMap();
        this.counter = counter;
    }

    @Override
    public void orWith(BitmapCounter another) {
        if (another instanceof RoaringBitmapCounter) {
            RoaringBitmapCounter input = (RoaringBitmapCounter)another;
            this.bitmap.or(input.bitmap);
            return;
        }
        throw new IllegalArgumentException("Unsupported type: " + another.getClass().getCanonicalName());
    }

    @Override
    public void andWith(BitmapCounter another) {
        if (another instanceof RoaringBitmapCounter) {
            RoaringBitmapCounter input = (RoaringBitmapCounter)another;
            this.bitmap.and(input.bitmap);
            return;
        }
        throw new IllegalArgumentException("Unsupported type: " + another.getClass().getCanonicalName());
    }

    @Override
    public void add(long value) {
        this.bitmap.add(new long[]{value});
    }

    @Override
    public void clear() {
        this.bitmap = new Roaring64NavigableMap();
    }

    @Override
    public long getCount() {
        if (this.counter != null) {
            return this.counter;
        }
        return this.bitmap.getLongCardinality();
    }

    @Override
    public int getMemBytes() {
        return this.bitmap.getSizeInBytes();
    }

    @Override
    public Iterator<Long> iterator() {
        return this.bitmap.iterator();
    }

    @Override
    public void write(ByteBuffer out) throws IOException {
        if (this.bitmap instanceof Roaring64NavigableMap) {
            this.bitmap.runOptimize();
        }
        if (out.remaining() < this.bitmap.getSizeInBytes()) {
            throw new BufferOverflowException();
        }
        try (DataOutputStream dos = new DataOutputStream((OutputStream)new ByteBufferOutputStream(out));){
            this.bitmap.serialize((DataOutput)dos);
        }
    }

    @Override
    public void write(ByteArrayOutputStream baos) throws IOException {
        try (DataOutputStream dos = new DataOutputStream(baos);){
            this.bitmap.serialize((DataOutput)dos);
        }
    }

    @Override
    public void readFields(ByteBuffer in) throws IOException {
        ByteBufferBackedInputStream bbi = new ByteBufferBackedInputStream(in);
        this.bitmap.deserialize((DataInput)new DataInputStream((InputStream)bbi));
    }

    @Override
    public int peekLength(ByteBuffer in) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        return obj instanceof RoaringBitmapCounter && this.bitmap.equals((Object)((RoaringBitmapCounter)obj).bitmap);
    }

    public int hashCode() {
        return this.bitmap.hashCode();
    }

    public String toString() {
        return "RoaringBitmapCounter[" + this.getCount() + "]";
    }
}

