/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.optimization;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.optimization.AbstractOptStrategy;
import org.apache.kylin.metadata.cube.optimization.FrequencyMap;
import org.apache.kylin.metadata.cube.optimization.GarbageLayoutType;
import org.apache.kylin.metadata.favorite.FavoriteRule;
import org.apache.kylin.metadata.favorite.FavoriteRuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowFreqLayoutOptStrategy
extends AbstractOptStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LowFreqLayoutOptStrategy.class);

    public LowFreqLayoutOptStrategy() {
        this.setType(GarbageLayoutType.LOW_FREQUENCY);
    }

    @Override
    public Set<Long> doCollect(List<LayoutEntity> inputLayouts, NDataflow dataflow, boolean needLog) {
        Map<Long, FrequencyMap> hitFrequencyMap = dataflow.getLayoutHitCount();
        HashSet garbageLayouts = Sets.newHashSet();
        FavoriteRuleManager ruleManager = FavoriteRuleManager.getInstance(dataflow.getProject());
        int days = FavoriteRule.getTimeWindowLength(ruleManager.getValue("frequency_time_window"));
        Integer lowFrequency = Integer.parseInt(ruleManager.getValue("low_frequency_threshold"));
        inputLayouts.forEach(layout -> {
            if (TimeUtil.minusDays((long)System.currentTimeMillis(), (int)days) >= layout.getUpdateTime()) {
                FrequencyMap frequencyMap = (FrequencyMap)hitFrequencyMap.get(layout.getId());
                if (frequencyMap == null) {
                    frequencyMap = new FrequencyMap();
                }
                if (frequencyMap.isLowFrequency(days, lowFrequency)) {
                    garbageLayouts.add(layout.getId());
                }
            }
        });
        if (needLog) {
            log.info("In dataflow({}), LowFreqLayoutGcStrategy found garbageLayouts: {}", (Object)dataflow.getId(), (Object)garbageLayouts);
        }
        return garbageLayouts;
    }

    @Override
    protected void skipOptimizeIndex(List<LayoutEntity> inputLayouts) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (!kylinConfig.isLowFreqStrategyConsiderTableIndex()) {
            inputLayouts.removeIf(layout -> IndexEntity.isTableIndex(layout.getId()));
        }
    }
}

