/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.recommendation.candidate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.NavigableMap;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.annotation.Clarification;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.recommendation.candidate.LayoutMetric;
import org.apache.kylin.metadata.recommendation.entity.CCRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.DimensionRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.LayoutRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.MeasureRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.RecItemV2;

@Clarification(priority=Clarification.Priority.MAJOR, msg="Enterprise")
public class RawRecItem {
    public static final String IMPORTED = "IMPORTED";
    public static final String QUERY_HISTORY = "QUERY_HISTORY";
    public static final String INDEX_PLANNER = "INDEX_PLANNER";
    private static final String TYPE_ERROR_FORMAT = "incorrect raw recommendation type(%d), type value must from 1 to 4 included";
    private static final String STATE_ERROR_FORMAT = "incorrect raw recommendation state(%d), type value must from 0 to 4 included";
    private int id;
    private String project;
    private String modelID;
    private String uniqueFlag;
    private int semanticVersion;
    private RawRecType type;
    private RecItemV2 recEntity;
    private RawRecState state;
    private long createTime;
    private long updateTime;
    private int[] dependIDs;
    private long mvcc;
    private LayoutMetric layoutMetric;
    private int hitCount;
    private double cost;
    private double totalLatencyOfLastDay;
    private double totalTime;
    private double maxTime;
    private double minTime;
    private String queryHistoryInfo;
    private String recSource;
    private String reservedField2;
    private String reservedField3;

    public RawRecItem() {
    }

    public RawRecItem(String project, String modelID, int semanticVersion, RawRecType type) {
        this();
        this.project = project;
        this.modelID = modelID;
        this.semanticVersion = semanticVersion;
        this.type = type;
    }

    @JsonIgnore
    public boolean isOutOfDate(int semanticVersion) {
        return this.getSemanticVersion() < semanticVersion;
    }

    @JsonIgnore
    public boolean isAgg() {
        Preconditions.checkState((boolean)this.isLayoutRec());
        return ((LayoutRecItemV2)this.getRecEntity()).isAgg();
    }

    @JsonIgnore
    public boolean isLayoutRec() {
        return RawRecType.ADDITIONAL_LAYOUT == this.getType() || RawRecType.REMOVAL_LAYOUT == this.getType();
    }

    @JsonIgnore
    public boolean isAddLayoutRec() {
        return this.getType() == RawRecType.ADDITIONAL_LAYOUT;
    }

    @JsonIgnore
    public boolean isRemoveLayoutRec() {
        return this.getType() == RawRecType.REMOVAL_LAYOUT;
    }

    @JsonIgnore
    public boolean isAdditionalRecItemSavable() {
        Preconditions.checkState((boolean)this.isAddLayoutRec());
        if (IMPORTED.equalsIgnoreCase(this.recSource)) {
            return true;
        }
        return this.getLayoutMetric() != null;
    }

    public void cleanLayoutStatistics() {
        this.setLayoutMetric(null);
        this.setHitCount(0);
        this.setCost(0.0);
        this.setTotalLatencyOfLastDay(0.0);
        this.setTotalTime(0.0);
        this.setMaxTime(0.0);
        this.setMinTime(0.0);
        this.setQueryHistoryInfo(null);
    }

    public void restoreIfNeed() {
        if (this.state == RawRecState.DISCARD) {
            this.state = RawRecState.INITIAL;
        }
    }

    public void updateCost(CostMethod costMethod, long currentTime, int effectiveDays) {
        long dayStart = this.getDateInMillis(currentTime);
        double newCost = 0.0;
        if (costMethod == CostMethod.HIT_COUNT) {
            NavigableMap<Long, Integer> frequencyMap = this.getLayoutMetric().getFrequencyMap().getDateFrequency();
            for (int days = 0; days < effectiveDays; ++days) {
                newCost += (double)frequencyMap.getOrDefault(dayStart - (long)days * 86400000L, 0).intValue();
            }
        } else {
            LayoutMetric.LatencyMap latencyMap = this.getLayoutMetric().getLatencyMap();
            for (int days = 0; days < effectiveDays; ++days) {
                newCost += latencyMap.getLatencyByDate(dayStart - (long)days * 86400000L) / Math.pow(Math.E, days);
            }
        }
        this.setCost(newCost);
    }

    private long getDateInMillis(long queryTime) {
        return TimeUtil.getDayStart((long)queryTime);
    }

    public static int[] toDependIds(String jsonString) {
        try {
            return (int[])JsonUtil.readValue((String)jsonString, int[].class);
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot deserialize depend id correctly", e);
        }
    }

    public static RawRecType toRecType(byte recType) {
        switch (recType) {
            case 1: {
                return RawRecType.COMPUTED_COLUMN;
            }
            case 2: {
                return RawRecType.DIMENSION;
            }
            case 3: {
                return RawRecType.MEASURE;
            }
            case 4: {
                return RawRecType.ADDITIONAL_LAYOUT;
            }
            case 5: {
                return RawRecType.REMOVAL_LAYOUT;
            }
        }
        throw new IllegalStateException(String.format(Locale.ROOT, TYPE_ERROR_FORMAT, recType));
    }

    public static RawRecState toRecState(byte stateType) {
        switch (stateType) {
            case 0: {
                return RawRecState.INITIAL;
            }
            case 1: {
                return RawRecState.RECOMMENDED;
            }
            case 2: {
                return RawRecState.APPLIED;
            }
            case 3: {
                return RawRecState.DISCARD;
            }
            case 4: {
                return RawRecState.BROKEN;
            }
        }
        throw new IllegalStateException(String.format(Locale.ROOT, STATE_ERROR_FORMAT, stateType));
    }

    public static RecItemV2 toRecItem(String jsonString, byte recType) {
        try {
            switch (recType) {
                case 1: {
                    return (RecItemV2)JsonUtil.readValue((String)jsonString, CCRecItemV2.class);
                }
                case 2: {
                    return (RecItemV2)JsonUtil.readValue((String)jsonString, DimensionRecItemV2.class);
                }
                case 3: {
                    return (RecItemV2)JsonUtil.readValue((String)jsonString, MeasureRecItemV2.class);
                }
                case 4: 
                case 5: {
                    return (RecItemV2)JsonUtil.readValue((String)jsonString, LayoutRecItemV2.class);
                }
            }
            throw new IllegalStateException(String.format(Locale.ROOT, TYPE_ERROR_FORMAT, recType));
        }
        catch (IOException | IllegalStateException e) {
            throw new IllegalStateException("cannot deserialize recommendation entity.", e);
        }
    }

    @JsonIgnore
    public IndexRecType getLayoutRecType() {
        Preconditions.checkArgument((boolean)this.isLayoutRec());
        if (this.isAgg() && this.isAddLayoutRec()) {
            return IndexRecType.ADD_AGG_INDEX;
        }
        if (this.isAgg() && this.isRemoveLayoutRec()) {
            return IndexRecType.REMOVE_AGG_INDEX;
        }
        if (this.isAddLayoutRec()) {
            return IndexRecType.ADD_TABLE_INDEX;
        }
        return IndexRecType.REMOVE_TABLE_INDEX;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String getModelID() {
        return this.modelID;
    }

    @Generated
    public String getUniqueFlag() {
        return this.uniqueFlag;
    }

    @Generated
    public int getSemanticVersion() {
        return this.semanticVersion;
    }

    @Generated
    public RawRecType getType() {
        return this.type;
    }

    @Generated
    public RecItemV2 getRecEntity() {
        return this.recEntity;
    }

    @Generated
    public RawRecState getState() {
        return this.state;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public long getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public int[] getDependIDs() {
        return this.dependIDs;
    }

    @Generated
    public long getMvcc() {
        return this.mvcc;
    }

    @Generated
    public LayoutMetric getLayoutMetric() {
        return this.layoutMetric;
    }

    @Generated
    public int getHitCount() {
        return this.hitCount;
    }

    @Generated
    public double getCost() {
        return this.cost;
    }

    @Generated
    public double getTotalLatencyOfLastDay() {
        return this.totalLatencyOfLastDay;
    }

    @Generated
    public double getTotalTime() {
        return this.totalTime;
    }

    @Generated
    public double getMaxTime() {
        return this.maxTime;
    }

    @Generated
    public double getMinTime() {
        return this.minTime;
    }

    @Generated
    public String getQueryHistoryInfo() {
        return this.queryHistoryInfo;
    }

    @Generated
    public String getRecSource() {
        return this.recSource;
    }

    @Generated
    public String getReservedField2() {
        return this.reservedField2;
    }

    @Generated
    public String getReservedField3() {
        return this.reservedField3;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setModelID(String modelID) {
        this.modelID = modelID;
    }

    @Generated
    public void setUniqueFlag(String uniqueFlag) {
        this.uniqueFlag = uniqueFlag;
    }

    @Generated
    public void setSemanticVersion(int semanticVersion) {
        this.semanticVersion = semanticVersion;
    }

    @Generated
    public void setType(RawRecType type) {
        this.type = type;
    }

    @Generated
    public void setRecEntity(RecItemV2 recEntity) {
        this.recEntity = recEntity;
    }

    @Generated
    public void setState(RawRecState state) {
        this.state = state;
    }

    @Generated
    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    @Generated
    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setDependIDs(int[] dependIDs) {
        this.dependIDs = dependIDs;
    }

    @Generated
    public void setMvcc(long mvcc) {
        this.mvcc = mvcc;
    }

    @Generated
    public void setLayoutMetric(LayoutMetric layoutMetric) {
        this.layoutMetric = layoutMetric;
    }

    @Generated
    public void setHitCount(int hitCount) {
        this.hitCount = hitCount;
    }

    @Generated
    public void setCost(double cost) {
        this.cost = cost;
    }

    @Generated
    public void setTotalLatencyOfLastDay(double totalLatencyOfLastDay) {
        this.totalLatencyOfLastDay = totalLatencyOfLastDay;
    }

    @Generated
    public void setTotalTime(double totalTime) {
        this.totalTime = totalTime;
    }

    @Generated
    public void setMaxTime(double maxTime) {
        this.maxTime = maxTime;
    }

    @Generated
    public void setMinTime(double minTime) {
        this.minTime = minTime;
    }

    @Generated
    public void setQueryHistoryInfo(String queryHistoryInfo) {
        this.queryHistoryInfo = queryHistoryInfo;
    }

    @Generated
    public void setRecSource(String recSource) {
        this.recSource = recSource;
    }

    @Generated
    public void setReservedField2(String reservedField2) {
        this.reservedField2 = reservedField2;
    }

    @Generated
    public void setReservedField3(String reservedField3) {
        this.reservedField3 = reservedField3;
    }

    @Generated
    public String toString() {
        return "RawRecItem(id=" + this.getId() + ", project=" + this.getProject() + ", modelID=" + this.getModelID() + ", uniqueFlag=" + this.getUniqueFlag() + ", semanticVersion=" + this.getSemanticVersion() + ", type=" + (Object)((Object)this.getType()) + ", recEntity=" + this.getRecEntity() + ", state=" + (Object)((Object)this.getState()) + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", dependIDs=" + Arrays.toString(this.getDependIDs()) + ", mvcc=" + this.getMvcc() + ", layoutMetric=" + this.getLayoutMetric() + ", hitCount=" + this.getHitCount() + ", cost=" + this.getCost() + ", totalLatencyOfLastDay=" + this.getTotalLatencyOfLastDay() + ", totalTime=" + this.getTotalTime() + ", maxTime=" + this.getMaxTime() + ", minTime=" + this.getMinTime() + ", queryHistoryInfo=" + this.getQueryHistoryInfo() + ", recSource=" + this.getRecSource() + ", reservedField2=" + this.getReservedField2() + ", reservedField3=" + this.getReservedField3() + ")";
    }

    public static enum CostMethod {
        HIT_COUNT,
        TIME_DECAY;


        public static CostMethod getCostMethod(String project) {
            String method = NProjectManager.getInstance(KylinConfig.getInstanceFromEnv()).getProject(project).getConfig().getRecommendationCostMethod();
            return CostMethod.valueOf(method);
        }
    }

    public static enum IndexRecType {
        ADD_AGG_INDEX,
        REMOVE_AGG_INDEX,
        ADD_TABLE_INDEX,
        REMOVE_TABLE_INDEX;

    }

    public static enum RawRecState {
        INITIAL(0),
        RECOMMENDED(1),
        APPLIED(2),
        DISCARD(3),
        BROKEN(4);

        private final int id;

        public int id() {
            return this.id;
        }

        private RawRecState(int id) {
            this.id = id;
        }
    }

    public static enum RawRecType {
        COMPUTED_COLUMN(1),
        DIMENSION(2),
        MEASURE(3),
        ADDITIONAL_LAYOUT(4),
        REMOVAL_LAYOUT(5);

        private final int id;

        public int id() {
            return this.id;
        }

        private RawRecType(int id) {
            this.id = id;
        }
    }
}

