/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.rules.ImmutableOLAPJoinPushThroughJoinRule2;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Permutation;
import org.apache.calcite.util.mapping.AbstractTargetMapping;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.immutables.value.Value;

@Value.Enclosing
public class OLAPJoinPushThroughJoinRule2
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = new OLAPJoinPushThroughJoinRule2("OLAPJoinPushThroughJoinRule2", LogicalJoin.class, RelFactories.LOGICAL_BUILDER);

    protected OLAPJoinPushThroughJoinRule2(Config config) {
        super(config);
    }

    public OLAPJoinPushThroughJoinRule2(String description, Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withDescription(description).withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(joinClass));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        this.onMatchRight(call);
    }

    private void onMatchRight(RelOptRuleCall call) {
        Join topJoin = (Join)call.rel(0);
        Project projectOnBottomJoin = (Project)call.rel(1);
        Join bottomJoin = (Join)call.rel(2);
        Object relC = call.rel(5);
        RelNode relA = bottomJoin.getLeft();
        RelNode relB = bottomJoin.getRight();
        RelOptCluster cluster = topJoin.getCluster();
        Permutation projectPermu = projectOnBottomJoin.getPermutation();
        Permutation inverseProjectPermu = projectPermu.inverse();
        int aCount = relA.getRowType().getFieldCount();
        int bCount = relB.getRowType().getFieldCount();
        int cCount = relC.getRowType().getFieldCount();
        ImmutableBitSet bBitSetBelowProject = ImmutableBitSet.range(aCount, aCount + bCount);
        ImmutableBitSet bBitSetAboveProject = Mappings.apply((Mapping)inverseProjectPermu, bBitSetBelowProject);
        AbstractTargetMapping extendedProjectPerm = this.createAbstractTargetMapping(Mappings.append(projectPermu, Mappings.createIdentity(cCount)));
        if (topJoin.getJoinType() == JoinRelType.RIGHT && bottomJoin.getJoinType() == JoinRelType.INNER) {
            return;
        }
        ArrayList<RexNode> intersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> nonIntersecting = new ArrayList<RexNode>();
        OLAPJoinPushThroughJoinRule2.split(topJoin.getCondition(), bBitSetAboveProject, intersecting, nonIntersecting);
        if (nonIntersecting.isEmpty()) {
            return;
        }
        ArrayList<RexNode> bottomIntersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> bottomNonIntersecting = new ArrayList<RexNode>();
        OLAPJoinPushThroughJoinRule2.split(bottomJoin.getCondition(), bBitSetBelowProject, bottomIntersecting, bottomNonIntersecting);
        Preconditions.checkState((boolean)bottomNonIntersecting.isEmpty());
        Mappings.TargetMapping tempMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, 0, aCount, aCount + cCount, aCount, bCount, aCount, aCount + bCount, cCount);
        Mapping thruProjectMapping = Mappings.multiply(extendedProjectPerm, this.createAbstractTargetMapping(tempMapping));
        ArrayList newBottomList = new ArrayList();
        new RexPermuteInputsShuttle((Mappings.TargetMapping)thruProjectMapping, new RelNode[]{relA, relC}).visitList(nonIntersecting, newBottomList);
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RexNode newBottomCondition = RexUtil.composeConjunction(rexBuilder, newBottomList, false);
        Join newBottomJoin = bottomJoin.copy(bottomJoin.getTraitSet(), newBottomCondition, relA, (RelNode)relC, topJoin.getJoinType(), bottomJoin.isSemiJoinDone());
        Mappings.TargetMapping nonThruProjectMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, 0, aCount, aCount + cCount, aCount, bCount, aCount, aCount + bCount, cCount);
        ArrayList newTopList = new ArrayList();
        new RexPermuteInputsShuttle((Mappings.TargetMapping)thruProjectMapping, newBottomJoin, relB).visitList(intersecting, newTopList);
        new RexPermuteInputsShuttle(nonThruProjectMapping, newBottomJoin, relB).visitList(bottomIntersecting, newTopList);
        RexNode newTopCondition = RexUtil.composeConjunction(rexBuilder, newTopList, false);
        Join newTopJoin = topJoin.copy(topJoin.getTraitSet(), newTopCondition, newBottomJoin, relB, bottomJoin.getJoinType(), topJoin.isSemiJoinDone());
        assert (!Mappings.isIdentity(thruProjectMapping));
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newTopJoin);
        relBuilder.project((Iterable<? extends RexNode>)relBuilder.fields(thruProjectMapping));
        call.transformTo(relBuilder.build());
    }

    private AbstractTargetMapping createAbstractTargetMapping(final Mappings.TargetMapping targetMapping) {
        return new AbstractTargetMapping(targetMapping.getSourceCount(), targetMapping.getTargetCount()){

            @Override
            public int getTargetOpt(int source) {
                return targetMapping.getTargetOpt(source);
            }
        };
    }

    static void split(RexNode condition, ImmutableBitSet bitSet, List<RexNode> intersecting, List<RexNode> nonIntersecting) {
        for (RexNode node : RelOptUtil.conjunctions(condition)) {
            ImmutableBitSet inputBitSet = RelOptUtil.InputFinder.bits(node);
            if (bitSet.intersects(inputBitSet)) {
                intersecting.add(node);
                continue;
            }
            nonIntersecting.add(node);
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableOLAPJoinPushThroughJoinRule2.Config.of().withDescription("OLAPJoinPushThroughJoinRule2").withOperandFor(LogicalJoin.class);

        @Override
        default public OLAPJoinPushThroughJoinRule2 toRule() {
            return new OLAPJoinPushThroughJoinRule2(this);
        }

        default public Config withOperandFor(Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b0 -> b0.operand(joinClass).inputs(b1 -> b1.operand(Project.class).predicate(input -> input.getPermutation() != null).inputs(b2 -> b2.operand(joinClass).inputs(b11 -> b11.operand(RelNode.class).anyInputs(), b12 -> b12.operand(RelNode.class).predicate(relNode -> !(relNode instanceof TableScan)).anyInputs())), b2 -> b2.operand(TableScan.class).anyInputs())).as(Config.class);
        }
    }
}

