/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorIntersects;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SpatialReference;
import java.util.Objects;
import org.apache.calcite.linq4j.function.Deterministic;
import org.apache.calcite.linq4j.function.Strict;
import org.apache.calcite.util.Util;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;

@Deterministic
@Strict
public class Geometries {
    static final int NO_SRID = 0;
    private static final SpatialReference SPATIAL_REFERENCE = SpatialReference.create((int)4326);

    private Geometries() {
    }

    static UnsupportedOperationException todo() {
        return new UnsupportedOperationException();
    }

    protected static Geom bind(Geometry geometry, int srid) {
        if (srid == 0) {
            return new SimpleGeom(geometry);
        }
        return Geometries.bind(geometry, SpatialReference.create((int)srid));
    }

    static MapGeom bind(Geometry geometry, SpatialReference sr) {
        return new MapGeom(new MapGeometry(geometry, sr));
    }

    static Geom makeLine(Geom ... geoms) {
        return Geometries.makeLine((Iterable<? extends Geom>)ImmutableList.copyOf((Object[])geoms));
    }

    public static Geom makeLine(Iterable<? extends Geom> geoms) {
        Polyline g = new Polyline();
        Point p = null;
        for (Geom geom : geoms) {
            if (!(geom.g() instanceof Point)) continue;
            Point prev = p;
            p = (Point)geom.g();
            if (prev == null) continue;
            Line line = new Line();
            line.setStart(prev);
            line.setEnd(p);
            g.addSegment((Segment)line, false);
        }
        return new SimpleGeom((Geometry)g);
    }

    static Geom point(double x, double y) {
        Point g = new Point(x, y);
        return new SimpleGeom((Geometry)g);
    }

    public static Type type(Geometry g) {
        switch (g.getType()) {
            case Point: {
                return Type.POINT;
            }
            case Polyline: {
                return Type.LINESTRING;
            }
            case Polygon: {
                return Type.POLYGON;
            }
            case MultiPoint: {
                return Type.MULTIPOINT;
            }
            case Envelope: {
                return Type.POLYGON;
            }
            case Line: {
                return Type.LINESTRING;
            }
            case Unknown: {
                return Type.Geometry;
            }
        }
        throw new AssertionError(g);
    }

    static Envelope envelope(Geometry g) {
        Envelope env = new Envelope();
        g.queryEnvelope(env);
        return env;
    }

    static boolean intersects(Geometry g1, Geometry g2, SpatialReference sr) {
        OperatorIntersects op = (OperatorIntersects)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Intersects);
        return op.execute(g1, g2, sr, null);
    }

    static Geom buffer(Geom geom, double bufferSize, int quadSegCount, CapStyle endCapStyle, JoinStyle joinStyle, float mitreLimit) {
        Util.discard((Object)((Object)endCapStyle) + ":" + (Object)((Object)joinStyle) + ":" + mitreLimit + ":" + quadSegCount);
        throw Geometries.todo();
    }

    static class MapGeom
    implements Geom {
        final MapGeometry mg;

        MapGeom(MapGeometry mg) {
            this.mg = Objects.requireNonNull(mg, "mg");
        }

        public String toString() {
            return this.mg.toString();
        }

        @Override
        public int compareTo(Geom o) {
            return this.toString().compareTo(o.toString());
        }

        @Override
        public Geometry g() {
            return this.mg.getGeometry();
        }

        @Override
        public Type type() {
            return Geometries.type(this.mg.getGeometry());
        }

        @Override
        public SpatialReference sr() {
            return this.mg.getSpatialReference();
        }

        @Override
        public Geom transform(int srid) {
            if (srid == 0) {
                return new SimpleGeom(this.mg.getGeometry());
            }
            if (srid == this.mg.getSpatialReference().getID()) {
                return this;
            }
            return Geometries.bind(Objects.requireNonNull(this.mg.getGeometry()), srid);
        }

        @Override
        public Geom wrap(Geometry g) {
            return Geometries.bind(g, this.mg.getSpatialReference());
        }
    }

    static class SimpleGeom
    implements Geom {
        final Geometry g;

        SimpleGeom(Geometry g) {
            this.g = Objects.requireNonNull(g, "g");
        }

        public String toString() {
            return this.g.toString();
        }

        @Override
        public int compareTo(Geom o) {
            return this.toString().compareTo(o.toString());
        }

        @Override
        public Geometry g() {
            return this.g;
        }

        @Override
        public Type type() {
            return Geometries.type(this.g);
        }

        @Override
        public SpatialReference sr() {
            return SPATIAL_REFERENCE;
        }

        @Override
        public Geom transform(int srid) {
            if (srid == SPATIAL_REFERENCE.getID()) {
                return this;
            }
            return Geometries.bind(this.g, srid);
        }

        @Override
        public Geom wrap(Geometry g) {
            return new SimpleGeom(g);
        }
    }

    public static interface Geom
    extends Comparable<Geom> {
        public Geometry g();

        public Type type();

        public SpatialReference sr();

        public Geom transform(int var1);

        public Geom wrap(Geometry var1);
    }

    public static enum Type {
        Geometry(0),
        POINT(1),
        LINESTRING(2),
        POLYGON(3),
        MULTIPOINT(4),
        MULTILINESTRING(5),
        MULTIPOLYGON(6),
        GEOMCOLLECTION(7),
        CURVE(13),
        SURFACE(14),
        POLYHEDRALSURFACE(15);

        final int code;

        private Type(int code) {
            this.code = code;
        }
    }

    static enum JoinStyle {
        ROUND,
        MITRE,
        BEVEL;


        static JoinStyle of(String value) {
            switch (value) {
                case "round": {
                    return ROUND;
                }
                case "mitre": 
                case "miter": {
                    return MITRE;
                }
                case "bevel": {
                    return BEVEL;
                }
            }
            throw new IllegalArgumentException("unknown join value: " + value);
        }
    }

    static enum CapStyle {
        ROUND,
        FLAT,
        SQUARE;


        static CapStyle of(String value) {
            switch (value) {
                case "round": {
                    return ROUND;
                }
                case "flat": 
                case "butt": {
                    return FLAT;
                }
                case "square": {
                    return SQUARE;
                }
            }
            throw new IllegalArgumentException("unknown endcap value: " + value);
        }
    }
}

