/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.config.external.loader;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import io.kyligence.config.external.loader.NacosExternalConfigLoader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.core.env.Environment;

public class NacosLoggingConfigLoader
extends NacosExternalConfigLoader {
    private static final Logger logger = LoggerFactory.getLogger(NacosLoggingConfigLoader.class);
    LoggingSystem loggingSystem = LoggingSystem.get((ClassLoader)this.getClass().getClassLoader());

    public NacosLoggingConfigLoader(Map<String, String> properties, NacosConfigProperties nacosConfigProperties, Environment environment) {
        super(properties, nacosConfigProperties, environment);
    }

    @Override
    public void innerReceive(String configInfo) {
        StringReader reader = new StringReader(configInfo);
        Properties properties = new Properties();
        try {
            properties.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.loggingSystem == null) {
            this.loggingSystem = LoggingSystem.get((ClassLoader)this.getClass().getClassLoader());
        }
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            Object key = prop.getKey();
            Object level = prop.getValue();
            if (!(key instanceof String) || !(level instanceof String)) continue;
            logger.debug("set log level: {}={}", key, level);
            try {
                this.loggingSystem.setLogLevel((String)key, LogLevel.valueOf((String)((String)level)));
            }
            catch (Exception e) {
                logger.warn("set log level failed: {}={}", new Object[]{key, level, e});
            }
        }
    }
}

