/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import jodd.Jodd;
import jodd.io.FileUtil;
import jodd.util.ClassLoaderUtil;
import jodd.util.ClassPathURLs;
import jodd.util.StringUtil;

public class ClassPathUtil {
    public static File[] getDefaultClasspath() {
        return ClassPathUtil.getDefaultClasspath(ClassLoaderUtil.getDefaultClassLoader());
    }

    public static File[] getDefaultClasspath(ClassLoader classLoader) {
        TreeSet<File> classpaths = new TreeSet<File>();
        while (classLoader != null) {
            URL[] urls = ClassPathURLs.of(classLoader, null);
            if (urls != null) {
                for (URL u : urls) {
                    File f = FileUtil.toContainerFile((URL)u);
                    if (f == null || !f.exists()) continue;
                    try {
                        f = f.getCanonicalFile();
                        boolean newElement = classpaths.add(f);
                        if (!newElement) continue;
                        ClassPathUtil.addInnerClasspathItems(classpaths, f);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            classLoader = classLoader.getParent();
        }
        File[] result = new File[classpaths.size()];
        return classpaths.toArray(result);
    }

    private static void addInnerClasspathItems(Set<File> classpaths, File item) {
        String[] tokens;
        Manifest manifest = ClassLoaderUtil.getClasspathItemManifest((File)item);
        if (manifest == null) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        if (attributes == null) {
            return;
        }
        String s = attributes.getValue(Attributes.Name.CLASS_PATH);
        if (s == null) {
            return;
        }
        String base = ClassLoaderUtil.getClasspathItemBaseDir((File)item);
        for (String t : tokens = StringUtil.splitc((String)s, (char)' ')) {
            File file;
            try {
                file = new File(base, t);
                file = file.getCanonicalFile();
                if (!file.exists()) {
                    file = null;
                }
            }
            catch (Exception ignore) {
                file = null;
            }
            if (file == null) {
                try {
                    file = new File(t);
                    file = file.getCanonicalFile();
                    if (!file.exists()) {
                        file = null;
                    }
                }
                catch (Exception ignore) {
                    file = null;
                }
            }
            if (file == null) {
                try {
                    URL url = new URL(t);
                    file = new File(url.getFile());
                    file = file.getCanonicalFile();
                    if (!file.exists()) {
                        file = null;
                    }
                }
                catch (Exception ignore) {
                    file = null;
                }
            }
            if (file == null || !file.exists()) continue;
            classpaths.add(file);
        }
    }

    public static String classLocation(Class clazz) {
        return clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
    }

    public static String joddLocation() {
        return ClassPathUtil.classLocation(Jodd.class);
    }
}

