/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest;

import java.io.IOException;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeSystem;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@Order(value=-2147483646)
public class JobNodeFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobNodeFilter.class);
    private static final String ERROR = "error";
    private static final String API_ERROR = "/api/error";
    private static final String FILTER_PASS = "filter_pass";
    private static Set<String> jobNodeAbandonApiSet = Sets.newHashSet();
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    ClusterManager clusterManager;

    public void doFilter(ServletRequest servletRequest, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (this.checkJobNodeAbandon(kylinConfig, request, response, chain)) {
            return;
        }
        chain.doFilter((ServletRequest)request, response);
    }

    private boolean checkJobNodeAbandon(KylinConfig kylinConfig, HttpServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean isJobNodePass;
        boolean bl = isJobNodePass = jobNodeAbandonApiSet.stream().filter(request.getRequestURI()::contains).count() == 0L;
        if (!isJobNodePass) {
            if (kylinConfig.isQueryNode()) {
                request.setAttribute(FILTER_PASS, (Object)"true");
                chain.doFilter((ServletRequest)request, response);
            } else {
                request.setAttribute(ERROR, (Object)new KylinException((ErrorCodeProducer)ErrorCodeSystem.JOB_NODE_API_INVALID, new Object[0]));
                request.getRequestDispatcher(API_ERROR).forward((ServletRequest)request, response);
            }
            return true;
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        log.info("init query request filter");
    }

    public void destroy() {
    }

    static {
        jobNodeAbandonApiSet.add("/data_range/latest_data");
        jobNodeAbandonApiSet.add("/kylin/api/tables/partition_column_format");
    }
}

