/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.utils.ExecutableHandleUtils;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableHandler;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.MergerInfo;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkSnapshotBuildingStep
extends NSparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkSnapshotBuildingStep.class);

    public NSparkSnapshotBuildingStep(String sparkSubmitClassName) {
        this.setSparkSubmitClassName(sparkSubmitClassName);
        this.setName("Build Snapshot");
    }

    public NSparkSnapshotBuildingStep(Object notSetId) {
        super(notSetId);
    }

    @Override
    protected Set<String> getMetadataDumpList(KylinConfig config) {
        HashSet dumpList = Sets.newHashSet();
        String table = this.getParam("table");
        NTableMetadataManager tblMgr = NTableMetadataManager.getInstance((KylinConfig)config, (String)this.getProject());
        TableDesc tableDesc = tblMgr.getTableDesc(table);
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)config).getProject(this.getProject());
        TableExtDesc tableExtDesc = tblMgr.getTableExtIfExists(tableDesc);
        if (tableExtDesc != null) {
            dumpList.add(tableExtDesc.getResourcePath());
        }
        dumpList.add(tableDesc.getResourcePath());
        dumpList.add(projectInstance.getResourcePath());
        dumpList.addAll(this.getLogicalViewMetaDumpList(config));
        return dumpList;
    }

    @Override
    public ExecuteResult doWork(JobContext context) throws ExecuteException {
        ExecuteResult result = super.doWork(context);
        if (!result.succeed()) {
            return result;
        }
        this.checkNeedQuit(true);
        MergerInfo mergerInfo = new MergerInfo(this.project, ExecutableHandler.HandlerType.SNAPSHOT);
        mergerInfo.addTaskMergeInfo((AbstractExecutable)this);
        ExecutableHandleUtils.mergeMetadataForTable(this.project, mergerInfo);
        return result;
    }

    @Generated
    public NSparkSnapshotBuildingStep() {
    }

    public static class Mockup {
        public static void main(String[] args) {
            String msg = String.format(Locale.ROOT, "%s.main() invoked, args: %s", Mockup.class, Arrays.toString(args));
            logger.info(msg);
        }
    }
}

