/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.source;

import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.NSparkCubingEngine;
import org.apache.kylin.engine.spark.source.NSparkCubingSourceInput;
import org.apache.kylin.engine.spark.source.NSparkMetadataExplorer;
import org.apache.kylin.engine.spark.source.NSparkTable;
import org.apache.kylin.metadata.model.IBuildable;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.ISampleDataDeployer;
import org.apache.kylin.source.ISource;
import org.apache.kylin.source.ISourceMetadataExplorer;

public class NSparkDataSource
implements ISource {
    public NSparkDataSource(KylinConfig config) {
    }

    public ISourceMetadataExplorer getSourceMetadataExplorer() {
        return new NSparkMetadataExplorer();
    }

    public <I> I adaptToBuildEngine(Class<I> engineInterface) {
        if (engineInterface == NSparkCubingEngine.NSparkCubingSource.class) {
            return (I)new NSparkCubingSourceInput();
        }
        throw new IllegalArgumentException("Unsupported engine interface: " + engineInterface);
    }

    public IReadableTable createReadableTable(TableDesc tableDesc) {
        return new NSparkTable(tableDesc);
    }

    public SegmentRange enrichSourcePartitionBeforeBuild(IBuildable buildable, SegmentRange srcPartition) {
        return srcPartition;
    }

    public ISampleDataDeployer getSampleDataDeployer() {
        return new NSparkMetadataExplorer();
    }

    public SegmentRange getSegmentRange(String start, String end) {
        start = StringUtils.isEmpty((CharSequence)start) ? "0" : start;
        end = StringUtils.isEmpty((CharSequence)end) ? "9223372036854775807" : end;
        return new SegmentRange.TimePartitionedSegmentRange(Long.valueOf(Long.parseLong(start)), Long.valueOf(Long.parseLong(end)));
    }

    public boolean supportBuildSnapShotByPartition() {
        return true;
    }
}

