/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.recommendation.entity.CCRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.DimensionRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.LayoutRecItemV2;
import org.apache.kylin.metadata.recommendation.entity.MeasureRecItemV2;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.springframework.beans.BeanUtils;

public class ContextOutput
implements Serializable {
    private Map<String, AccelerateInfo> accelerateInfoMap = Maps.newHashMap();
    private List<ModelContextOutput> modelContextOutputs = Lists.newArrayList();

    public static void merge(AbstractContext targetContext, ContextOutput output) {
        BeanUtils.copyProperties((Object)output, (Object)targetContext);
        for (ModelContextOutput modelContextOutput : output.getModelContextOutputs()) {
            AbstractContext.ModelContext modelContext = new AbstractContext.ModelContext(targetContext, null);
            BeanUtils.copyProperties((Object)modelContextOutput, (Object)modelContext);
            targetContext.getModelContexts().add(modelContext);
        }
        targetContext.getAccelerateInfoMap().forEach((sql, accInfo) -> accInfo.getRelatedLayouts().forEach(relation -> relation.setSql((String)sql)));
    }

    public static ContextOutput from(AbstractContext sourceContext) {
        ContextOutput output = new ContextOutput();
        BeanUtils.copyProperties((Object)sourceContext, (Object)output);
        for (AbstractContext.ModelContext modelContext : sourceContext.getModelContexts()) {
            ModelContextOutput modelOutput = new ModelContextOutput();
            if (modelContext.getTargetModel() != null) {
                List targetCCs = modelContext.getTargetModel().getComputedColumnDescs();
                modelContext.getTargetModel().setComputedColumnUuids(targetCCs.stream().map(RootPersistentEntity::getUuid).collect(Collectors.toList()));
            }
            BeanUtils.copyProperties((Object)modelContext, (Object)modelOutput);
            output.getModelContextOutputs().add(modelOutput);
        }
        return output;
    }

    @Generated
    public ContextOutput() {
    }

    @Generated
    public Map<String, AccelerateInfo> getAccelerateInfoMap() {
        return this.accelerateInfoMap;
    }

    @Generated
    public List<ModelContextOutput> getModelContextOutputs() {
        return this.modelContextOutputs;
    }

    @Generated
    public void setAccelerateInfoMap(Map<String, AccelerateInfo> accelerateInfoMap) {
        this.accelerateInfoMap = accelerateInfoMap;
    }

    @Generated
    public void setModelContextOutputs(List<ModelContextOutput> modelContextOutputs) {
        this.modelContextOutputs = modelContextOutputs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextOutput)) {
            return false;
        }
        ContextOutput other = (ContextOutput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, AccelerateInfo> this$accelerateInfoMap = this.getAccelerateInfoMap();
        Map<String, AccelerateInfo> other$accelerateInfoMap = other.getAccelerateInfoMap();
        if (this$accelerateInfoMap == null ? other$accelerateInfoMap != null : !((Object)this$accelerateInfoMap).equals(other$accelerateInfoMap)) {
            return false;
        }
        List<ModelContextOutput> this$modelContextOutputs = this.getModelContextOutputs();
        List<ModelContextOutput> other$modelContextOutputs = other.getModelContextOutputs();
        return !(this$modelContextOutputs == null ? other$modelContextOutputs != null : !((Object)this$modelContextOutputs).equals(other$modelContextOutputs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContextOutput;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, AccelerateInfo> $accelerateInfoMap = this.getAccelerateInfoMap();
        result = result * 59 + ($accelerateInfoMap == null ? 43 : ((Object)$accelerateInfoMap).hashCode());
        List<ModelContextOutput> $modelContextOutputs = this.getModelContextOutputs();
        result = result * 59 + ($modelContextOutputs == null ? 43 : ((Object)$modelContextOutputs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContextOutput(accelerateInfoMap=" + this.getAccelerateInfoMap() + ", modelContextOutputs=" + this.getModelContextOutputs() + ")";
    }

    public static class ModelContextOutput
    implements Serializable {
        private NDataModel targetModel;
        private NDataModel originModel;
        private IndexPlan targetIndexPlan;
        private IndexPlan originIndexPlan;
        private Map<String, CCRecItemV2> ccRecItemMap = Maps.newHashMap();
        private Map<String, DimensionRecItemV2> dimensionRecItemMap = Maps.newHashMap();
        private Map<String, MeasureRecItemV2> measureRecItemMap = Maps.newHashMap();
        private Map<String, LayoutRecItemV2> indexRexItemMap = Maps.newHashMap();
        private boolean snapshotSelected;
        private Map<String, ComputedColumnDesc> usedCC = Maps.newHashMap();

        @Generated
        public ModelContextOutput() {
        }

        @Generated
        public NDataModel getTargetModel() {
            return this.targetModel;
        }

        @Generated
        public NDataModel getOriginModel() {
            return this.originModel;
        }

        @Generated
        public IndexPlan getTargetIndexPlan() {
            return this.targetIndexPlan;
        }

        @Generated
        public IndexPlan getOriginIndexPlan() {
            return this.originIndexPlan;
        }

        @Generated
        public Map<String, CCRecItemV2> getCcRecItemMap() {
            return this.ccRecItemMap;
        }

        @Generated
        public Map<String, DimensionRecItemV2> getDimensionRecItemMap() {
            return this.dimensionRecItemMap;
        }

        @Generated
        public Map<String, MeasureRecItemV2> getMeasureRecItemMap() {
            return this.measureRecItemMap;
        }

        @Generated
        public Map<String, LayoutRecItemV2> getIndexRexItemMap() {
            return this.indexRexItemMap;
        }

        @Generated
        public boolean isSnapshotSelected() {
            return this.snapshotSelected;
        }

        @Generated
        public Map<String, ComputedColumnDesc> getUsedCC() {
            return this.usedCC;
        }

        @Generated
        public void setTargetModel(NDataModel targetModel) {
            this.targetModel = targetModel;
        }

        @Generated
        public void setOriginModel(NDataModel originModel) {
            this.originModel = originModel;
        }

        @Generated
        public void setTargetIndexPlan(IndexPlan targetIndexPlan) {
            this.targetIndexPlan = targetIndexPlan;
        }

        @Generated
        public void setOriginIndexPlan(IndexPlan originIndexPlan) {
            this.originIndexPlan = originIndexPlan;
        }

        @Generated
        public void setCcRecItemMap(Map<String, CCRecItemV2> ccRecItemMap) {
            this.ccRecItemMap = ccRecItemMap;
        }

        @Generated
        public void setDimensionRecItemMap(Map<String, DimensionRecItemV2> dimensionRecItemMap) {
            this.dimensionRecItemMap = dimensionRecItemMap;
        }

        @Generated
        public void setMeasureRecItemMap(Map<String, MeasureRecItemV2> measureRecItemMap) {
            this.measureRecItemMap = measureRecItemMap;
        }

        @Generated
        public void setIndexRexItemMap(Map<String, LayoutRecItemV2> indexRexItemMap) {
            this.indexRexItemMap = indexRexItemMap;
        }

        @Generated
        public void setSnapshotSelected(boolean snapshotSelected) {
            this.snapshotSelected = snapshotSelected;
        }

        @Generated
        public void setUsedCC(Map<String, ComputedColumnDesc> usedCC) {
            this.usedCC = usedCC;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModelContextOutput)) {
                return false;
            }
            ModelContextOutput other = (ModelContextOutput)o;
            if (!other.canEqual(this)) {
                return false;
            }
            NDataModel this$targetModel = this.getTargetModel();
            NDataModel other$targetModel = other.getTargetModel();
            if (this$targetModel == null ? other$targetModel != null : !this$targetModel.equals(other$targetModel)) {
                return false;
            }
            NDataModel this$originModel = this.getOriginModel();
            NDataModel other$originModel = other.getOriginModel();
            if (this$originModel == null ? other$originModel != null : !this$originModel.equals(other$originModel)) {
                return false;
            }
            IndexPlan this$targetIndexPlan = this.getTargetIndexPlan();
            IndexPlan other$targetIndexPlan = other.getTargetIndexPlan();
            if (this$targetIndexPlan == null ? other$targetIndexPlan != null : !this$targetIndexPlan.equals(other$targetIndexPlan)) {
                return false;
            }
            IndexPlan this$originIndexPlan = this.getOriginIndexPlan();
            IndexPlan other$originIndexPlan = other.getOriginIndexPlan();
            if (this$originIndexPlan == null ? other$originIndexPlan != null : !this$originIndexPlan.equals(other$originIndexPlan)) {
                return false;
            }
            Map<String, CCRecItemV2> this$ccRecItemMap = this.getCcRecItemMap();
            Map<String, CCRecItemV2> other$ccRecItemMap = other.getCcRecItemMap();
            if (this$ccRecItemMap == null ? other$ccRecItemMap != null : !((Object)this$ccRecItemMap).equals(other$ccRecItemMap)) {
                return false;
            }
            Map<String, DimensionRecItemV2> this$dimensionRecItemMap = this.getDimensionRecItemMap();
            Map<String, DimensionRecItemV2> other$dimensionRecItemMap = other.getDimensionRecItemMap();
            if (this$dimensionRecItemMap == null ? other$dimensionRecItemMap != null : !((Object)this$dimensionRecItemMap).equals(other$dimensionRecItemMap)) {
                return false;
            }
            Map<String, MeasureRecItemV2> this$measureRecItemMap = this.getMeasureRecItemMap();
            Map<String, MeasureRecItemV2> other$measureRecItemMap = other.getMeasureRecItemMap();
            if (this$measureRecItemMap == null ? other$measureRecItemMap != null : !((Object)this$measureRecItemMap).equals(other$measureRecItemMap)) {
                return false;
            }
            Map<String, LayoutRecItemV2> this$indexRexItemMap = this.getIndexRexItemMap();
            Map<String, LayoutRecItemV2> other$indexRexItemMap = other.getIndexRexItemMap();
            if (this$indexRexItemMap == null ? other$indexRexItemMap != null : !((Object)this$indexRexItemMap).equals(other$indexRexItemMap)) {
                return false;
            }
            if (this.isSnapshotSelected() != other.isSnapshotSelected()) {
                return false;
            }
            Map<String, ComputedColumnDesc> this$usedCC = this.getUsedCC();
            Map<String, ComputedColumnDesc> other$usedCC = other.getUsedCC();
            return !(this$usedCC == null ? other$usedCC != null : !((Object)this$usedCC).equals(other$usedCC));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ModelContextOutput;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            NDataModel $targetModel = this.getTargetModel();
            result = result * 59 + ($targetModel == null ? 43 : $targetModel.hashCode());
            NDataModel $originModel = this.getOriginModel();
            result = result * 59 + ($originModel == null ? 43 : $originModel.hashCode());
            IndexPlan $targetIndexPlan = this.getTargetIndexPlan();
            result = result * 59 + ($targetIndexPlan == null ? 43 : $targetIndexPlan.hashCode());
            IndexPlan $originIndexPlan = this.getOriginIndexPlan();
            result = result * 59 + ($originIndexPlan == null ? 43 : $originIndexPlan.hashCode());
            Map<String, CCRecItemV2> $ccRecItemMap = this.getCcRecItemMap();
            result = result * 59 + ($ccRecItemMap == null ? 43 : ((Object)$ccRecItemMap).hashCode());
            Map<String, DimensionRecItemV2> $dimensionRecItemMap = this.getDimensionRecItemMap();
            result = result * 59 + ($dimensionRecItemMap == null ? 43 : ((Object)$dimensionRecItemMap).hashCode());
            Map<String, MeasureRecItemV2> $measureRecItemMap = this.getMeasureRecItemMap();
            result = result * 59 + ($measureRecItemMap == null ? 43 : ((Object)$measureRecItemMap).hashCode());
            Map<String, LayoutRecItemV2> $indexRexItemMap = this.getIndexRexItemMap();
            result = result * 59 + ($indexRexItemMap == null ? 43 : ((Object)$indexRexItemMap).hashCode());
            result = result * 59 + (this.isSnapshotSelected() ? 79 : 97);
            Map<String, ComputedColumnDesc> $usedCC = this.getUsedCC();
            result = result * 59 + ($usedCC == null ? 43 : ((Object)$usedCC).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ContextOutput.ModelContextOutput(targetModel=" + this.getTargetModel() + ", originModel=" + this.getOriginModel() + ", targetIndexPlan=" + this.getTargetIndexPlan() + ", originIndexPlan=" + this.getOriginIndexPlan() + ", ccRecItemMap=" + this.getCcRecItemMap() + ", dimensionRecItemMap=" + this.getDimensionRecItemMap() + ", measureRecItemMap=" + this.getMeasureRecItemMap() + ", indexRexItemMap=" + this.getIndexRexItemMap() + ", snapshotSelected=" + this.isSnapshotSelected() + ", usedCC=" + this.getUsedCC() + ")";
        }
    }
}

