/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.util.List;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.x.discovery.ProviderStrategy;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;
import org.apache.curator.x.discovery.strategies.RandomStrategy;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.ZookeeperConfig;
import org.apache.kylin.common.util.ClusterConstant;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.common.util.ZookeeperAclBuilder;
import org.apache.kylin.tool.discovery.ServiceInstanceSerializer;
import org.apache.kylin.tool.kerberos.KerberosLoginTask;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorOperator
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CuratorOperator.class);
    private CuratorFramework zkClient;

    public CuratorOperator() {
        KerberosLoginTask kerberosLoginTask = new KerberosLoginTask();
        kerberosLoginTask.execute();
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        String connectString = ZookeeperConfig.getZKConnectString();
        ZookeeperAclBuilder aclBuilder = new ZookeeperAclBuilder().invoke();
        this.zkClient = aclBuilder.setZKAclBuilder(CuratorFrameworkFactory.builder()).connectString(connectString).sessionTimeoutMs(ZookeeperConfig.geZKClientSessionTimeoutMs()).connectionTimeoutMs(ZookeeperConfig.geZKClientConnectionTimeoutMs()).retryPolicy((RetryPolicy)retryPolicy).build();
        this.zkClient.start();
    }

    public static void main(String[] args) {
        int ret = 0;
        try (CuratorOperator curatorOperator = new CuratorOperator();){
            if (curatorOperator.isJobNodeExist()) {
                ret = 1;
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            ret = 1;
        }
        Unsafe.systemExit((int)ret);
    }

    public boolean isJobNodeExist() throws Exception {
        return this.checkNodeExist(ClusterConstant.ALL) || this.checkNodeExist(ClusterConstant.JOB);
    }

    private boolean checkNodeExist(String serverMode) throws Exception {
        String identifier = KylinConfig.getInstanceFromEnv().getMetadataUrlUniqueId();
        String nodePath = "/kylin/" + identifier + "/services/" + serverMode;
        Stat stat = (Stat)this.zkClient.checkExists().forPath(nodePath);
        if (stat == null) {
            return false;
        }
        List childNodes = (List)this.zkClient.getChildren().forPath(nodePath);
        return childNodes != null && !childNodes.isEmpty();
    }

    @Override
    public void close() throws Exception {
        if (this.zkClient != null) {
            this.zkClient.close();
        }
    }

    public String getAddress() throws Exception {
        String identifier = KylinConfig.getInstanceFromEnv().getMetadataUrlUniqueId();
        ServiceDiscovery serviceDiscovery = ServiceDiscoveryBuilder.builder(Object.class).client(this.zkClient).basePath("/kylin/" + identifier + "/services").serializer(new ServiceInstanceSerializer<Object>(Object.class)).build();
        serviceDiscovery.start();
        ServiceProvider provider = serviceDiscovery.serviceProviderBuilder().serviceName("all").providerStrategy((ProviderStrategy)new RandomStrategy()).build();
        provider.start();
        ServiceInstance serviceInstance = provider.getInstance();
        if (serviceInstance == null) {
            return null;
        }
        return serviceInstance.getAddress() + ":" + serviceInstance.getPort();
    }
}

