/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.flipkart.zjsonpatch.JsonDiff;
import com.flipkart.zjsonpatch.JsonPatch;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.apache.log4j.Logger;

public class RawResource {
    @Generated
    private static final Logger log = Logger.getLogger(RawResource.class);
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="meta_key")
    private String metaKey;
    @JsonProperty(value="content")
    private byte[] content;
    private byte[] contentDiff;
    @JsonProperty(value="ts")
    private Long ts;
    @JsonProperty(value="mvcc")
    private long mvcc;
    @JsonProperty(value="reserved_filed_1")
    private String reservedFiled1;
    @JsonProperty(value="reserved_filed_2")
    private byte[] reservedFiled2;
    @JsonProperty(value="reserved_filed_3")
    private byte[] reservedFiled3;
    private boolean broken = false;

    public RawResource(String metaKey, ByteSource byteSource, long timestamp, long mvcc) {
        this.metaKey = metaKey;
        this.ts = timestamp;
        this.mvcc = mvcc;
        if (byteSource != null) {
            try (InputStream is = byteSource.openStream();
                 DataInputStream din = new DataInputStream(is);){
                this.content = IOUtils.toByteArray((InputStream)din);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error when construct RawResource from byteSource.", e);
            }
        }
    }

    public ByteSource getByteSource() {
        return this.content == null ? null : ByteSource.wrap((byte[])this.content);
    }

    public ByteSource getDiffByteSource() {
        return this.contentDiff == null ? null : ByteSource.wrap((byte[])this.contentDiff);
    }

    public String generateKeyWithType() {
        return MetadataType.mergeKeyWithType(this.getMetaKey(), this.getMetaType());
    }

    public MetadataType getMetaType() {
        return Arrays.stream(MetadataType.values()).filter(t -> t.getResourceClass().equals(this.getClass())).findAny().orElseThrow(() -> new IllegalStateException("Can't find MetadataType for class: " + this.getClass()));
    }

    public String generateFilePath() {
        if (this.getMetaType() == MetadataType.ALL) {
            return this.getMetaKey();
        }
        return this.generateKeyWithType() + ".json";
    }

    /*
     * Exception decompiling
     */
    public static RawResource constructResource(MetadataType type, ByteSource byteSource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static RawResource constructResource(MetadataType type, ByteSource byteSource, long ts, long mvcc, String metaKey) {
        RawResource raw = RawResource.constructResource(type, byteSource);
        raw.setMvcc(mvcc);
        raw.setTs(ts);
        raw.setMetaKey(metaKey);
        return raw;
    }

    public void fillContentDiffFromRaw(RawResource before) {
        RawResource.fillContentDiffFromRaw(before, this);
    }

    private static void fillContentDiffFromRaw(RawResource before, RawResource after) {
        if (after.getContent() == null) {
            return;
        }
        if (before == null && after.getMvcc() > 0L) {
            throw new IllegalStateException("No pre-update data found, unable to calculate json diff! metaKey: " + after.getMetaKey() + ", mvcc: " + after.getMvcc());
        }
        try {
            if (before == null) {
                return;
            }
            if (before.getMvcc() != after.getMvcc() - 1L) {
                throw new KylinRuntimeException("Mvcc not match, unable to calculate json diff! metaKey: " + after.getMetaKey() + ", before mvcc: " + before.getMvcc() + ", after mvcc: " + after.getMvcc());
            }
            JsonNode beforeJson = JsonUtil.readValue(before.getContent(), JsonNode.class);
            JsonNode afterJson = JsonUtil.readValue(after.getContent(), JsonNode.class);
            after.setContentDiff(JsonDiff.asJson((JsonNode)beforeJson, (JsonNode)afterJson).toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new KylinRuntimeException("Failed to fill content diff from raw.", e);
        }
    }

    public static ByteSource applyContentDiffFromRaw(RawResource before, RawResource diff) {
        if (diff.getDiffByteSource() == null) {
            return null;
        }
        if ((before == null || before.getByteSource() == null) && diff.getMvcc() > 0L) {
            throw new KylinRuntimeException("No pre-update data found, unable to calculate json diff! metaKey: " + diff.getMetaKey() + ", mvcc: " + diff.getMvcc());
        }
        try {
            if (before == null) {
                return diff.getDiffByteSource();
            }
            JsonNode beforeJson = JsonUtil.readValue(before.getContent(), JsonNode.class);
            JsonNode patch = JsonUtil.readValue(diff.getContentDiff(), JsonNode.class);
            JsonPatch.applyInPlace((JsonNode)patch, (JsonNode)beforeJson);
            return ByteSource.wrap((byte[])JsonUtil.writeValueAsBytes(beforeJson));
        }
        catch (IOException e) {
            throw new KylinRuntimeException("Failed to fill content diff from raw.", e);
        }
    }

    public String getProject() {
        return "_global";
    }

    public String getModelUuid() {
        return null;
    }

    public void setProject(String resPath) {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getMetaKey() {
        return this.metaKey;
    }

    @Generated
    public byte[] getContent() {
        return this.content;
    }

    @Generated
    public byte[] getContentDiff() {
        return this.contentDiff;
    }

    @Generated
    public Long getTs() {
        return this.ts;
    }

    @Generated
    public long getMvcc() {
        return this.mvcc;
    }

    @Generated
    public String getReservedFiled1() {
        return this.reservedFiled1;
    }

    @Generated
    public byte[] getReservedFiled2() {
        return this.reservedFiled2;
    }

    @Generated
    public byte[] getReservedFiled3() {
        return this.reservedFiled3;
    }

    @Generated
    public boolean isBroken() {
        return this.broken;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setMetaKey(String metaKey) {
        this.metaKey = metaKey;
    }

    @Generated
    public void setContent(byte[] content) {
        this.content = content;
    }

    @Generated
    public void setContentDiff(byte[] contentDiff) {
        this.contentDiff = contentDiff;
    }

    @Generated
    public void setTs(Long ts) {
        this.ts = ts;
    }

    @Generated
    public void setMvcc(long mvcc) {
        this.mvcc = mvcc;
    }

    @Generated
    public void setReservedFiled1(String reservedFiled1) {
        this.reservedFiled1 = reservedFiled1;
    }

    @Generated
    public void setReservedFiled2(byte[] reservedFiled2) {
        this.reservedFiled2 = reservedFiled2;
    }

    @Generated
    public void setReservedFiled3(byte[] reservedFiled3) {
        this.reservedFiled3 = reservedFiled3;
    }

    @Generated
    public void setBroken(boolean broken) {
        this.broken = broken;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawResource)) {
            return false;
        }
        RawResource other = (RawResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        String this$metaKey = this.getMetaKey();
        String other$metaKey = other.getMetaKey();
        if (this$metaKey == null ? other$metaKey != null : !this$metaKey.equals(other$metaKey)) {
            return false;
        }
        if (!Arrays.equals(this.getContent(), other.getContent())) {
            return false;
        }
        if (!Arrays.equals(this.getContentDiff(), other.getContentDiff())) {
            return false;
        }
        Long this$ts = this.getTs();
        Long other$ts = other.getTs();
        if (this$ts == null ? other$ts != null : !((Object)this$ts).equals(other$ts)) {
            return false;
        }
        if (this.getMvcc() != other.getMvcc()) {
            return false;
        }
        String this$reservedFiled1 = this.getReservedFiled1();
        String other$reservedFiled1 = other.getReservedFiled1();
        if (this$reservedFiled1 == null ? other$reservedFiled1 != null : !this$reservedFiled1.equals(other$reservedFiled1)) {
            return false;
        }
        if (!Arrays.equals(this.getReservedFiled2(), other.getReservedFiled2())) {
            return false;
        }
        if (!Arrays.equals(this.getReservedFiled3(), other.getReservedFiled3())) {
            return false;
        }
        return this.isBroken() == other.isBroken();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RawResource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        String $metaKey = this.getMetaKey();
        result = result * 59 + ($metaKey == null ? 43 : $metaKey.hashCode());
        result = result * 59 + Arrays.hashCode(this.getContent());
        result = result * 59 + Arrays.hashCode(this.getContentDiff());
        Long $ts = this.getTs();
        result = result * 59 + ($ts == null ? 43 : ((Object)$ts).hashCode());
        long $mvcc = this.getMvcc();
        result = result * 59 + (int)($mvcc >>> 32 ^ $mvcc);
        String $reservedFiled1 = this.getReservedFiled1();
        result = result * 59 + ($reservedFiled1 == null ? 43 : $reservedFiled1.hashCode());
        result = result * 59 + Arrays.hashCode(this.getReservedFiled2());
        result = result * 59 + Arrays.hashCode(this.getReservedFiled3());
        result = result * 59 + (this.isBroken() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "RawResource(id=" + this.getId() + ", uuid=" + this.getUuid() + ", metaKey=" + this.getMetaKey() + ", content=" + Arrays.toString(this.getContent()) + ", contentDiff=" + Arrays.toString(this.getContentDiff()) + ", ts=" + this.getTs() + ", mvcc=" + this.getMvcc() + ", reservedFiled1=" + this.getReservedFiled1() + ", reservedFiled2=" + Arrays.toString(this.getReservedFiled2()) + ", reservedFiled3=" + Arrays.toString(this.getReservedFiled3()) + ", broken=" + this.isBroken() + ")";
    }

    @Generated
    public RawResource() {
    }

    @Generated
    public RawResource(Long id, String uuid, String metaKey, byte[] content, byte[] contentDiff, Long ts, long mvcc, String reservedFiled1, byte[] reservedFiled2, byte[] reservedFiled3, boolean broken) {
        this.id = id;
        this.uuid = uuid;
        this.metaKey = metaKey;
        this.content = content;
        this.contentDiff = contentDiff;
        this.ts = ts;
        this.mvcc = mvcc;
        this.reservedFiled1 = reservedFiled1;
        this.reservedFiled2 = reservedFiled2;
        this.reservedFiled3 = reservedFiled3;
        this.broken = broken;
    }

    public static class ByteSourceDeserializer
    extends JsonDeserializer<ByteSource> {
        public ByteSource deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            byte[] bytes = p.getBinaryValue();
            return ByteSource.wrap((byte[])bytes);
        }
    }

    public static class ByteSourceSerializer
    extends JsonSerializer<ByteSource> {
        public void serialize(ByteSource value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            byte[] bytes = value.read();
            gen.writeBinary(bytes);
        }
    }
}

