/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.memtarget;

import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.memory.memtarget.MemoryTargetVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingMemoryTarget
implements MemoryTarget {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingMemoryTarget.class);
    private final MemoryTarget delegated;

    public LoggingMemoryTarget(MemoryTarget delegated) {
        this.delegated = delegated;
    }

    @Override
    public long borrow(long size) {
        long before = this.usedBytes();
        long reserved = this.delegated.borrow(size);
        long after = this.usedBytes();
        LOGGER.info(String.format("Borrowed[%s]: %d + %d(%d) = %d", this.toString(), before, reserved, size, after));
        return reserved;
    }

    @Override
    public long repay(long size) {
        long before = this.usedBytes();
        long unreserved = this.delegated.repay(size);
        long after = this.usedBytes();
        LOGGER.info(String.format("Repaid[%s]: %d - %d(%d) = %d", this.toString(), before, unreserved, size, after));
        return unreserved;
    }

    @Override
    public long usedBytes() {
        return this.delegated.usedBytes();
    }

    @Override
    public <T> T accept(MemoryTargetVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public MemoryTarget delegated() {
        return this.delegated;
    }
}

