/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.alibaba.ttl.spi.TtlAttachments;
import com.alibaba.ttl.spi.TtlAttachmentsDelegate;
import com.alibaba.ttl.spi.TtlEnhanced;
import com.alibaba.ttl.spi.TtlWrapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class TtlRunnable
implements Runnable,
TtlWrapper<Runnable>,
TtlEnhanced,
TtlAttachments {
    private final AtomicReference<Object> capturedRef;
    private final Runnable runnable;
    private final boolean releaseTtlValueReferenceAfterRun;
    private final TtlAttachmentsDelegate ttlAttachment = new TtlAttachmentsDelegate();

    private TtlRunnable(@NonNull Runnable runnable, boolean releaseTtlValueReferenceAfterRun) {
        this.capturedRef = new AtomicReference<Object>(TransmittableThreadLocal.Transmitter.capture());
        this.runnable = runnable;
        this.releaseTtlValueReferenceAfterRun = releaseTtlValueReferenceAfterRun;
    }

    @Override
    public void run() {
        Object captured = this.capturedRef.get();
        if (captured == null || this.releaseTtlValueReferenceAfterRun && !this.capturedRef.compareAndSet(captured, null)) {
            throw new IllegalStateException("TTL value reference is released after run!");
        }
        Object backup = TransmittableThreadLocal.Transmitter.replay(captured);
        try {
            this.runnable.run();
        }
        finally {
            TransmittableThreadLocal.Transmitter.restore(backup);
        }
    }

    @NonNull
    public Runnable getRunnable() {
        return this.unwrap();
    }

    @Override
    @NonNull
    public Runnable unwrap() {
        return this.runnable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TtlRunnable that = (TtlRunnable)o;
        return this.runnable.equals(that.runnable);
    }

    public int hashCode() {
        return this.runnable.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + " - " + this.runnable.toString();
    }

    @Nullable
    public static TtlRunnable get(@Nullable Runnable runnable) {
        return TtlRunnable.get(runnable, false, false);
    }

    @Nullable
    public static TtlRunnable get(@Nullable Runnable runnable, boolean releaseTtlValueReferenceAfterRun) {
        return TtlRunnable.get(runnable, releaseTtlValueReferenceAfterRun, false);
    }

    @Nullable
    public static TtlRunnable get(@Nullable Runnable runnable, boolean releaseTtlValueReferenceAfterRun, boolean idempotent) {
        if (null == runnable) {
            return null;
        }
        if (runnable instanceof TtlEnhanced) {
            if (idempotent) {
                return (TtlRunnable)runnable;
            }
            throw new IllegalStateException("Already TtlRunnable!");
        }
        return new TtlRunnable(runnable, releaseTtlValueReferenceAfterRun);
    }

    @NonNull
    public static List<TtlRunnable> gets(@Nullable Collection<? extends Runnable> tasks) {
        return TtlRunnable.gets(tasks, false, false);
    }

    @NonNull
    public static List<TtlRunnable> gets(@Nullable Collection<? extends Runnable> tasks, boolean releaseTtlValueReferenceAfterRun) {
        return TtlRunnable.gets(tasks, releaseTtlValueReferenceAfterRun, false);
    }

    @NonNull
    public static List<TtlRunnable> gets(@Nullable Collection<? extends Runnable> tasks, boolean releaseTtlValueReferenceAfterRun, boolean idempotent) {
        if (null == tasks) {
            return Collections.emptyList();
        }
        ArrayList<TtlRunnable> copy = new ArrayList<TtlRunnable>();
        for (Runnable runnable : tasks) {
            copy.add(TtlRunnable.get(runnable, releaseTtlValueReferenceAfterRun, idempotent));
        }
        return copy;
    }

    @Nullable
    public static Runnable unwrap(@Nullable Runnable runnable) {
        if (!(runnable instanceof TtlRunnable)) {
            return runnable;
        }
        return ((TtlRunnable)runnable).getRunnable();
    }

    @NonNull
    public static List<Runnable> unwraps(@Nullable Collection<? extends Runnable> tasks) {
        if (null == tasks) {
            return Collections.emptyList();
        }
        ArrayList<Runnable> copy = new ArrayList<Runnable>();
        for (Runnable runnable : tasks) {
            if (!(runnable instanceof TtlRunnable)) {
                copy.add(runnable);
                continue;
            }
            copy.add(((TtlRunnable)runnable).getRunnable());
        }
        return copy;
    }

    @Override
    public void setTtlAttachment(@NonNull String key, Object value) {
        this.ttlAttachment.setTtlAttachment(key, value);
    }

    @Override
    public <T> T getTtlAttachment(@NonNull String key) {
        return this.ttlAttachment.getTtlAttachment(key);
    }
}

