/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.service.UserAclServiceSupporter;
import org.apache.kylin.rest.util.AclUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;

@Component(value="aclEvaluate")
public class AclEvaluate {
    @Autowired
    private AclUtil aclUtil;
    @Autowired(required=false)
    @Qualifier(value="userAclService")
    private UserAclServiceSupporter userAclService;

    private ProjectInstance getProjectInstance(String projectName) {
        Message msg = MsgPicker.getMsg();
        if (StringUtils.isEmpty((CharSequence)projectName)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PROJECT_NAME, msg.getEmptyProjectName());
        }
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ProjectInstance prjInstance = projectManager.getProject(projectName);
        if (prjInstance == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{projectName});
        }
        return prjInstance;
    }

    public void checkProjectQueryPermission(String projectName) {
        if (this.userAclService.canAdminUserQuery() || this.userAclService.hasUserAclPermissionInProject(projectName)) {
            return;
        }
        this.aclUtil.hasProjectDataQueryPermission(this.getProjectInstance(projectName));
    }

    public void checkProjectReadPermission(String projectName) {
        this.aclUtil.hasProjectReadPermission(this.getProjectInstance(projectName));
    }

    public void checkProjectOperationPermission(String projectName) {
        this.aclUtil.hasProjectOperationPermission(this.getProjectInstance(projectName));
    }

    public void checkProjectWritePermission(String projectName) {
        this.aclUtil.hasProjectWritePermission(this.getProjectInstance(projectName));
    }

    public void checkProjectAdminPermission(String projectName) {
        this.aclUtil.hasProjectAdminPermission(this.getProjectInstance(projectName));
    }

    public String getCurrentUserName() {
        return this.aclUtil.getCurrentUserName();
    }

    public boolean hasProjectReadPermission(ProjectInstance project) {
        try {
            this.aclUtil.hasProjectReadPermission(project);
        }
        catch (AccessDeniedException e) {
            return false;
        }
        return true;
    }

    public boolean hasProjectOperationPermission(ProjectInstance project) {
        try {
            this.aclUtil.hasProjectOperationPermission(project);
        }
        catch (AccessDeniedException e) {
            return false;
        }
        return true;
    }

    public boolean hasProjectWritePermission(ProjectInstance project) {
        try {
            this.aclUtil.hasProjectWritePermission(project);
        }
        catch (AccessDeniedException e) {
            return false;
        }
        return true;
    }

    public boolean hasProjectAdminPermission(String project) {
        return this.hasProjectAdminPermission(this.getProjectInstance(project));
    }

    public boolean hasProjectAdminPermission(ProjectInstance project) {
        try {
            this.aclUtil.hasProjectAdminPermission(project);
        }
        catch (AccessDeniedException e) {
            return false;
        }
        return true;
    }

    public void checkIsGlobalAdmin() {
        this.aclUtil.checkIsGlobalAdmin();
    }

    public void checkProjectOperationDesignPermission(String projectName) {
        boolean indexEnableOperatorDesign = KylinConfig.getInstanceFromEnv().isIndexEnableOperatorDesign();
        this.aclUtil.hasProjectOperationDesignPermission(this.getProjectInstance(projectName), indexEnableOperatorDesign);
    }
}

