/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import springfox.documentation.common.ExternalDocumentation;
import springfox.documentation.schema.ElementFacet;
import springfox.documentation.schema.ElementFacetSource;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.Xml;
import springfox.documentation.service.VendorExtension;

public class ModelFacets
implements ElementFacetSource {
    private final String title;
    private final String description;
    private final Boolean nullable;
    private final Boolean deprecated;
    private final Set<ElementFacet> elementFacets = new HashSet<ElementFacet>();
    private final ExternalDocumentation externalDocumentation;
    private final Xml xml;
    private final List<Example> examples = new ArrayList<Example>();
    private final List<VendorExtension> extensions = new ArrayList<VendorExtension>();

    public ModelFacets(String title, String description, Boolean nullable, Boolean deprecated, Collection<ElementFacet> facets, Xml xml, ExternalDocumentation externalDocumentation, List<Example> examples, List<VendorExtension> extensions) {
        this.title = title;
        this.nullable = nullable;
        this.deprecated = deprecated;
        this.elementFacets.addAll(facets);
        this.xml = xml;
        this.externalDocumentation = externalDocumentation;
        this.description = description;
        this.examples.addAll(examples);
        this.extensions.addAll(extensions);
    }

    public String getTitle() {
        return this.title;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public ExternalDocumentation getExternalDocumentation() {
        return this.externalDocumentation;
    }

    public List<Example> getExamples() {
        return this.examples;
    }

    public String getDescription() {
        return this.description;
    }

    public List<VendorExtension> getExtensions() {
        return this.extensions;
    }

    public Collection<ElementFacet> getFacets() {
        return this.elementFacets;
    }

    @Override
    public <T extends ElementFacet> Optional<T> elementFacet(Class<T> clazz) {
        return this.elementFacets.stream().filter(e -> e != null && e.getClass().isAssignableFrom(clazz)).map(clazz::cast).findFirst();
    }

    public Xml getXml() {
        return this.xml;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelFacets that = (ModelFacets)o;
        return Objects.equals(this.title, that.title) && Objects.equals(this.description, that.description) && Objects.equals(this.nullable, that.nullable) && Objects.equals(this.deprecated, that.deprecated) && Objects.equals(this.elementFacets, that.elementFacets) && Objects.equals(this.externalDocumentation, that.externalDocumentation) && Objects.equals(this.xml, that.xml) && Objects.equals(this.examples, that.examples) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.nullable, this.deprecated, this.elementFacets, this.externalDocumentation, this.xml, this.examples, this.extensions);
    }

    public String toString() {
        return "ModelFacets{title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", nullable=" + this.nullable + ", deprecated=" + this.deprecated + ", elementFacets=" + this.elementFacets + ", externalDocumentation=" + this.externalDocumentation + ", xml=" + this.xml + ", examples=" + this.examples + ", extensions=" + this.extensions + '}';
    }
}

