/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.enumeration;

import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.common.entity.enumeration.NodeHealthy;

public enum NodeStatus {
    Starting,
    Unlock,
    Locked,
    Idle,
    Busy,
    Running,
    ShuttingDown,
    Failed,
    Success;


    public static Boolean isAvailable(NodeStatus status) {
        if (Idle == status || Busy == status || Locked == status || Unlock == status || Running == status) {
            return true;
        }
        return false;
    }

    public static Boolean isLocked(NodeStatus status) {
        if (Busy == status || Locked == status || Idle == status) {
            return true;
        }
        return false;
    }

    public static Boolean isIdle(NodeStatus status) {
        if (Idle == status || Unlock == status) {
            return true;
        }
        return false;
    }

    public static Boolean isCompleted(NodeStatus status) {
        if (Success == status || Failed == status || ShuttingDown == status) {
            return true;
        }
        return false;
    }

    public static NodeStatus toNodeStatus(String status) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)status)) {
            throw new IllegalArgumentException("Invalid status : " + status + " cannot be matched in NodeStatus");
        }
        return NodeStatus.valueOf(status);
    }

    public static NodeHealthy isEngineNodeHealthy(NodeStatus status) {
        switch (status) {
            case Starting: 
            case Running: 
            case Busy: 
            case Idle: 
            case Locked: 
            case Unlock: 
            case Success: {
                return NodeHealthy.Healthy;
            }
            case Failed: 
            case ShuttingDown: {
                return NodeHealthy.UnHealthy;
            }
        }
        return NodeHealthy.UnHealthy;
    }
}

