/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface HiveMetaHook {
    public static final String ALTER_TABLE_OPERATION_TYPE = "alterTableOpType";
    public static final List<String> allowedAlterTypes = ImmutableList.of("ADDPROPS", "DROPPROPS");

    public void preCreateTable(Table var1) throws MetaException;

    public void rollbackCreateTable(Table var1) throws MetaException;

    public void commitCreateTable(Table var1) throws MetaException;

    public void preDropTable(Table var1) throws MetaException;

    public void rollbackDropTable(Table var1) throws MetaException;

    public void commitDropTable(Table var1, boolean var2) throws MetaException;

    default public void preAlterTable(Table table, EnvironmentContext context) throws MetaException {
        String alterOpType;
        String string = alterOpType = context == null ? null : context.getProperties().get(ALTER_TABLE_OPERATION_TYPE);
        if (alterOpType != null && !allowedAlterTypes.contains(alterOpType)) {
            throw new MetaException("ALTER TABLE can not be used for " + alterOpType + " to a non-native table ");
        }
    }
}

