/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.server.scheduler.impl;

import org.apache.linkis.cs.server.conf.ContextServerConf;
import org.apache.linkis.cs.server.scheduler.impl.CsExecutorExecutionManager;
import org.apache.linkis.scheduler.Scheduler;
import org.apache.linkis.scheduler.SchedulerContext;
import org.apache.linkis.scheduler.executer.ExecutorManager;
import org.apache.linkis.scheduler.queue.fifoqueue.FIFOGroupFactory;
import org.apache.linkis.scheduler.queue.parallelqueue.ParallelScheduler;
import org.apache.linkis.scheduler.queue.parallelqueue.ParallelSchedulerContextImpl;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={CsExecutorExecutionManager.class})
public class CsSchedulerBean {
    @Bean
    public SchedulerContext getSchedulerContext(CsExecutorExecutionManager csExecutorManager) {
        ParallelSchedulerContextImpl parallelSchedulerContext = new ParallelSchedulerContextImpl(3000);
        parallelSchedulerContext.setExecutorManager((ExecutorManager)csExecutorManager);
        if (parallelSchedulerContext.getOrCreateGroupFactory() instanceof FIFOGroupFactory) {
            FIFOGroupFactory groupFactory = (FIFOGroupFactory)parallelSchedulerContext.getOrCreateGroupFactory();
            groupFactory.setDefaultMaxRunningJobs(ContextServerConf.CS_SCHEDULER_MAX_RUNNING_JOBS);
            groupFactory.setDefaultMaxAskExecutorTimes(ContextServerConf.CS_SCHEDULER_MAX_ASK_EXECUTOR_TIMES);
        }
        return parallelSchedulerContext;
    }

    @Bean
    public Scheduler getScheduler(SchedulerContext context) {
        ParallelScheduler parallelScheduler = new ParallelScheduler(context);
        parallelScheduler.init();
        return parallelScheduler;
    }
}

