/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import io.swagger.models.ModelImpl;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import springfox.documentation.schema.CollectionElementFacet;
import springfox.documentation.schema.ElementFacetSource;
import springfox.documentation.schema.EnumerationFacet;
import springfox.documentation.schema.NumericElementFacet;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.schema.StringElementFacet;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.SimpleParameterSpecification;

public class EnumMapper {
    private EnumMapper() {
        throw new UnsupportedOperationException();
    }

    static ModelImpl maybeAddAllowableValuesToParameter(ModelImpl toReturn, AllowableValues allowableValues) {
        if (allowableValues instanceof AllowableListValues) {
            toReturn.setEnum(((AllowableListValues)allowableValues).getValues());
        }
        return toReturn;
    }

    static SerializableParameter maybeAddAllowableValuesToParameter(SerializableParameter toReturn, Property property, AllowableValues allowableValues) {
        if (allowableValues instanceof AllowableListValues) {
            toReturn.setEnum(((AllowableListValues)allowableValues).getValues());
        }
        if (allowableValues instanceof AllowableRangeValues) {
            AllowableRangeValues range = (AllowableRangeValues)allowableValues;
            if (property instanceof StringProperty) {
                toReturn.setMinLength(EnumMapper.safeInteger(range.getMin()));
                toReturn.setMaxLength(EnumMapper.safeInteger(range.getMax()));
            } else {
                toReturn.setMinimum(EnumMapper.safeBigDecimal(range.getMin()));
                toReturn.setExclusiveMinimum(range.getExclusiveMin());
                toReturn.setMaximum(EnumMapper.safeBigDecimal(range.getMax()));
                toReturn.setExclusiveMaximum(range.getExclusiveMax());
            }
        }
        return toReturn;
    }

    static SerializableParameter maybeAddAllowableValuesToParameter(SerializableParameter parameter, SimpleParameterSpecification parameterSpecification) {
        parameterSpecification.facetOfType(EnumerationFacet.class).ifPresent(e -> parameter.setEnum(e.getAllowedValues()));
        parameterSpecification.facetOfType(NumericElementFacet.class).ifPresent(range -> parameterSpecification.getModel().getScalar().ifPresent(s -> {
            if (s.getType() == ScalarType.STRING) {
                parameter.setMinLength(EnumMapper.safeConvertBigDecimalToInt(range.getMinimum()));
                parameter.setMaxLength(EnumMapper.safeConvertBigDecimalToInt(range.getMaximum()));
            } else {
                parameter.setMinimum(range.getMinimum());
                parameter.setExclusiveMinimum(range.getExclusiveMinimum());
                parameter.setMaximum(range.getMaximum());
                parameter.setExclusiveMaximum(range.getExclusiveMaximum());
            }
        }));
        parameterSpecification.facetOfType(StringElementFacet.class).ifPresent(string -> parameterSpecification.getModel().getScalar().ifPresent(s -> {
            if (s.getType() == ScalarType.STRING) {
                parameter.setMinLength(string.getMinLength());
                parameter.setMaxLength(string.getMaxLength());
                parameter.setPattern(string.getPattern());
            }
        }));
        parameterSpecification.getModel().getCollection().flatMap(collection -> parameterSpecification.facetOfType(CollectionElementFacet.class)).ifPresent(element -> {
            parameter.setMaxItems(element.getMaxItems());
            parameter.setMinItems(element.getMinItems());
            parameter.setUniqueItems(element.getUniqueItems());
        });
        return parameter;
    }

    private static Integer safeConvertBigDecimalToInt(BigDecimal bigDecimalValue) {
        return bigDecimalValue != null ? Integer.valueOf(bigDecimalValue.intValue()) : null;
    }

    static BigDecimal safeBigDecimal(String doubleString) {
        if (doubleString == null) {
            return null;
        }
        try {
            return new BigDecimal(doubleString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static Integer safeInteger(String doubleString) {
        if (doubleString == null) {
            return null;
        }
        try {
            return new BigDecimal(doubleString).intValue();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static Property maybeAddAllowableValues(Property property, AllowableValues allowableValues) {
        if (allowableValues instanceof AllowableListValues) {
            AllowableListValues listValues;
            if (property instanceof StringProperty) {
                StringProperty stringProperty = (StringProperty)property;
                listValues = (AllowableListValues)allowableValues;
                stringProperty.setEnum(listValues.getValues());
            } else if (property instanceof IntegerProperty) {
                IntegerProperty integerProperty = (IntegerProperty)property;
                listValues = (AllowableListValues)allowableValues;
                integerProperty.setEnum(EnumMapper.convert(listValues.getValues(), Integer.class));
            } else if (property instanceof LongProperty) {
                LongProperty longProperty = (LongProperty)property;
                listValues = (AllowableListValues)allowableValues;
                longProperty.setEnum(EnumMapper.convert(listValues.getValues(), Long.class));
            } else if (property instanceof DoubleProperty) {
                DoubleProperty doubleProperty = (DoubleProperty)property;
                listValues = (AllowableListValues)allowableValues;
                doubleProperty.setEnum(EnumMapper.convert(listValues.getValues(), Double.class));
            } else if (property instanceof FloatProperty) {
                FloatProperty floatProperty = (FloatProperty)property;
                listValues = (AllowableListValues)allowableValues;
                floatProperty.setEnum(EnumMapper.convert(listValues.getValues(), Float.class));
            }
        }
        if (allowableValues instanceof AllowableRangeValues) {
            if (property instanceof AbstractNumericProperty) {
                AbstractNumericProperty numeric = (AbstractNumericProperty)property;
                AllowableRangeValues range = (AllowableRangeValues)allowableValues;
                numeric.setMaximum(EnumMapper.safeBigDecimal(range.getMax()));
                numeric.exclusiveMaximum(range.getExclusiveMax());
                numeric.setMinimum(EnumMapper.safeBigDecimal(range.getMin()));
                numeric.exclusiveMinimum(range.getExclusiveMin());
            }
            if (property instanceof ArrayProperty) {
                ArrayProperty arrayProperty = (ArrayProperty)property;
                AllowableRangeValues allowableRangeValues = (AllowableRangeValues)allowableValues;
                arrayProperty.setMinItems(EnumMapper.safeInteger(allowableRangeValues.getMin()));
                arrayProperty.setMaxItems(EnumMapper.safeInteger(allowableRangeValues.getMax()));
            }
        }
        return property;
    }

    static Property maybeAddFacets(Property property, ElementFacetSource facets) {
        if (facets == null) {
            return property;
        }
        facets.elementFacet(EnumerationFacet.class).ifPresent(f -> {
            if (property instanceof StringProperty) {
                StringProperty stringProperty = (StringProperty)property;
                stringProperty.setEnum(f.getAllowedValues());
            } else if (property instanceof IntegerProperty) {
                IntegerProperty integerProperty = (IntegerProperty)property;
                integerProperty.setEnum(EnumMapper.convert(f.getAllowedValues(), Integer.class));
            } else if (property instanceof LongProperty) {
                LongProperty longProperty = (LongProperty)property;
                longProperty.setEnum(EnumMapper.convert(f.getAllowedValues(), Long.class));
            } else if (property instanceof DoubleProperty) {
                DoubleProperty doubleProperty = (DoubleProperty)property;
                doubleProperty.setEnum(EnumMapper.convert(f.getAllowedValues(), Double.class));
            } else if (property instanceof FloatProperty) {
                FloatProperty floatProperty = (FloatProperty)property;
                floatProperty.setEnum(EnumMapper.convert(f.getAllowedValues(), Float.class));
            }
        });
        if (property instanceof AbstractNumericProperty) {
            facets.elementFacet(NumericElementFacet.class).ifPresent(f -> {
                AbstractNumericProperty numeric = (AbstractNumericProperty)property;
                numeric.setMaximum(f.getMaximum());
                numeric.exclusiveMaximum(f.getExclusiveMaximum());
                numeric.setMinimum(f.getMinimum());
                numeric.exclusiveMinimum(f.getExclusiveMinimum());
            });
        }
        if (property instanceof ArrayProperty) {
            facets.elementFacet(CollectionElementFacet.class).ifPresent(f -> {
                ArrayProperty arrayProperty = (ArrayProperty)property;
                arrayProperty.setMinItems(f.getMinItems());
                arrayProperty.setMaxItems(f.getMaxItems());
            });
        }
        if (property instanceof StringProperty) {
            StringProperty stringProperty = (StringProperty)property;
            facets.elementFacet(StringElementFacet.class).ifPresent(f -> {
                stringProperty.maxLength(f.getMaxLength());
                stringProperty.minLength(f.getMinLength());
                if (f.getPattern() != null) {
                    stringProperty.pattern(f.getPattern());
                }
            });
        }
        return property;
    }

    private static <T extends Number> List<T> convert(List<String> values, Class<T> toType) {
        return values.stream().map(EnumMapper.converterOfType(toType)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static <T extends Number> Function<? super String, Optional<T>> converterOfType(Class<T> toType) {
        return input -> {
            try {
                if (Integer.class.equals((Object)toType)) {
                    return Optional.of(Integer.valueOf(input));
                }
                if (Long.class.equals((Object)toType)) {
                    return Optional.of(Long.valueOf(input));
                }
                if (Double.class.equals((Object)toType)) {
                    return Optional.of(Double.valueOf(input));
                }
                if (Float.class.equals((Object)toType)) {
                    return Optional.of(Float.valueOf(input));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return Optional.empty();
        };
    }
}

