/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.postag;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.cmdline.params.FineGrainedEvaluatorParams;
import opennlp.tools.cmdline.postag.POSEvaluationErrorListener;
import opennlp.tools.cmdline.postag.POSModelLoader;
import opennlp.tools.cmdline.postag.POSTaggerFineGrainedReportListener;
import opennlp.tools.postag.POSEvaluator;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerME;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class POSTaggerEvaluatorTool
extends AbstractEvaluatorTool<POSSample, EvalToolParams> {
    private static final Logger logger = LoggerFactory.getLogger(POSTaggerEvaluatorTool.class);

    public POSTaggerEvaluatorTool() {
        super(POSSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Measures the performance of the POS tagger model with the reference data";
    }

    @Override
    public void run(String format, String[] args) {
        super.run(format, args);
        POSModel model = (POSModel)new POSModelLoader().load(((EvalToolParams)this.params).getModel());
        POSEvaluationErrorListener missclassifiedListener = null;
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            missclassifiedListener = new POSEvaluationErrorListener();
        }
        POSTaggerFineGrainedReportListener reportListener = null;
        File reportFile = ((EvalToolParams)this.params).getReportOutputFile();
        FileOutputStream reportOutputStream = null;
        if (reportFile != null) {
            CmdLineUtil.checkOutputFile("Report Output File", reportFile);
            try {
                reportOutputStream = new FileOutputStream(reportFile);
                reportListener = new POSTaggerFineGrainedReportListener(reportOutputStream);
            }
            catch (FileNotFoundException e) {
                throw new TerminateToolException(-1, "IO error while creating POS Tagger fine-grained report file: " + e.getMessage());
            }
        }
        POSEvaluator evaluator = new POSEvaluator(new POSTaggerME(model), missclassifiedListener, reportListener);
        logger.info("Evaluating ... ");
        try {
            evaluator.evaluate(this.sampleStream);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading test data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        logger.info("done");
        if (reportListener != null) {
            logger.info("Writing fine-grained report to {}", (Object)((EvalToolParams)this.params).getReportOutputFile().getAbsolutePath());
            reportListener.writeReport();
            try {
                reportOutputStream.flush();
                ((OutputStream)reportOutputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        logger.info("Accuracy: {}", (Object)evaluator.getWordAccuracy());
    }

    static interface EvalToolParams
    extends EvaluatorParams,
    FineGrainedEvaluatorParams {
    }
}

