/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.commits;

import java.io.IOException;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.luke.models.commits.CommitsImpl;

public final class Segment {
    private String name;
    private int maxDoc;
    private long delGen;
    private int delCount;
    private String luceneVer;
    private String codecName;
    private String displaySize;
    private boolean useCompoundFile;

    static Segment of(SegmentCommitInfo segInfo) {
        Segment segment = new Segment();
        segment.name = segInfo.info.name;
        segment.maxDoc = segInfo.info.maxDoc();
        segment.delGen = segInfo.getDelGen();
        segment.delCount = segInfo.getDelCount();
        segment.luceneVer = segInfo.info.getVersion().toString();
        segment.codecName = segInfo.info.getCodec().getName();
        try {
            segment.displaySize = CommitsImpl.toDisplaySize(segInfo.sizeInBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        segment.useCompoundFile = segInfo.info.getUseCompoundFile();
        return segment;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxDoc() {
        return this.maxDoc;
    }

    public long getDelGen() {
        return this.delGen;
    }

    public int getDelCount() {
        return this.delCount;
    }

    public String getLuceneVer() {
        return this.luceneVer;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public String getDisplaySize() {
        return this.displaySize;
    }

    public boolean isUseCompoundFile() {
        return this.useCompoundFile;
    }

    private Segment() {
    }
}

