/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.streaming;

import org.apache.hadoop.io.WritableComparator;

public class StreamingDelimiters {
    private static final byte RECORD_END = 10;
    private static final byte PARAM_DELIM = 9;
    private static final byte NULL_BYTE = 45;
    private static final byte TUPLE_BEGIN = 40;
    private static final byte TUPLE_END = 41;
    private static final byte BAG_BEGIN = 123;
    private static final byte BAG_END = 125;
    private static final byte MAP_BEGIN = 91;
    private static final byte MAP_END = 93;
    private static final byte FIELD_DELIM = 44;
    private static final byte MAP_KEY_VALUE_DELIM = 35;
    private byte preWrapDelim;
    private byte postWrapDelim;
    private byte[] tupleBegin;
    private byte[] tupleEnd;
    private byte[] bagBegin;
    private byte[] bagEnd;
    private byte[] mapBegin;
    private byte[] mapEnd;
    private byte[] fieldDelim;
    private byte[] nullByte;
    private byte[] paramDelim;
    private byte[] recordEnd;

    public StreamingDelimiters() {
        this(0, 0, true);
    }

    public StreamingDelimiters(byte preWrapDelim, byte postWrapDelim, boolean useEmptyNull) {
        this.preWrapDelim = preWrapDelim;
        this.postWrapDelim = postWrapDelim;
        this.tupleBegin = this.getFullDelim((byte)40);
        this.tupleEnd = this.getFullDelim((byte)41);
        this.bagBegin = this.getFullDelim((byte)123);
        this.bagEnd = this.getFullDelim((byte)125);
        this.mapBegin = this.getFullDelim((byte)91);
        this.mapEnd = this.getFullDelim((byte)93);
        this.fieldDelim = this.getFullDelim((byte)44);
        this.nullByte = useEmptyNull ? new byte[0] : this.getFullDelim((byte)45);
        this.paramDelim = this.getFullDelim((byte)9);
        this.recordEnd = new byte[]{preWrapDelim, postWrapDelim, 10};
    }

    private byte[] getFullDelim(byte val) {
        if (this.preWrapDelim == 0) {
            return new byte[]{val};
        }
        return new byte[]{this.preWrapDelim, val, this.postWrapDelim};
    }

    public byte[] getTupleBegin() {
        return this.tupleBegin;
    }

    public byte[] getTupleEnd() {
        return this.tupleEnd;
    }

    public byte[] getBagBegin() {
        return this.bagBegin;
    }

    public byte[] getBagEnd() {
        return this.bagEnd;
    }

    public byte[] getMapBegin() {
        return this.mapBegin;
    }

    public byte[] getMapEnd() {
        return this.mapEnd;
    }

    public byte[] getFieldDelim() {
        return this.fieldDelim;
    }

    public byte getMapKeyDelim() {
        return 35;
    }

    public byte[] getNull() {
        return this.nullByte;
    }

    public byte[] getParamDelim() {
        return this.paramDelim;
    }

    public byte[] getRecordEnd() {
        return this.recordEnd;
    }

    public int updateDepth(byte[] buf, int currDepth, int index) {
        byte delimChar;
        if (index < 2 || this.preWrapDelim == 0 || buf[index - 2] != this.preWrapDelim || buf[index] != this.postWrapDelim) {
            return currDepth;
        }
        byte by = delimChar = this.preWrapDelim == 0 ? buf[index] : buf[index - 1];
        if (delimChar == 123 || delimChar == 40 || delimChar == 91) {
            return currDepth + 1;
        }
        if (delimChar == 125 || delimChar == 41 || delimChar == 93) {
            return currDepth - 1;
        }
        return currDepth;
    }

    public static boolean isDelimiter(byte[] delimiter, byte[] buf, int index, int depth, int endIndex) {
        return depth == 0 && (index == endIndex || index <= endIndex - 2 && WritableComparator.compareBytes((byte[])buf, (int)index, (int)delimiter.length, (byte[])delimiter, (int)0, (int)delimiter.length) == 0);
    }
}

