/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.net.UnknownHostException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestCIBadHostname {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCIBadHostname.class);
    private static HBaseTestingUtility testUtil;
    private static ConnectionImplementation conn;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        testUtil = HBaseTestingUtility.createLocalHTU();
        testUtil.startMiniCluster();
        conn = (ConnectionImplementation)testUtil.getConnection();
    }

    @AfterClass
    public static void teardownAfterClass() throws Exception {
        conn.close();
        testUtil.shutdownMiniCluster();
    }

    @Test(expected=UnknownHostException.class)
    public void testGetAdminBadHostname() throws Exception {
        ServerName master = testUtil.getHBaseCluster().getMaster().getServerName();
        try {
            conn.getAdmin(master);
        }
        catch (UnknownHostException uhe) {
            Assert.fail((String)"Obtaining admin to the cluster master should have succeeded");
        }
        ServerName badHost = ServerName.valueOf((String)"unknownhost.invalid:16000", (long)System.currentTimeMillis());
        conn.getAdmin(badHost);
        Assert.fail((String)"Obtaining admin to unresolvable hostname should have failed");
    }

    @Test(expected=UnknownHostException.class)
    public void testGetClientBadHostname() throws Exception {
        ServerName rs = testUtil.getHBaseCluster().getRegionServer(0).getServerName();
        try {
            conn.getClient(rs);
        }
        catch (UnknownHostException uhe) {
            Assert.fail((String)"Obtaining client to the cluster regionserver should have succeeded");
        }
        ServerName badHost = ServerName.valueOf((String)"unknownhost.invalid:16020", (long)System.currentTimeMillis());
        conn.getAdmin(badHost);
        Assert.fail((String)"Obtaining client to unresolvable hostname should have failed");
    }
}

