/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.procedure.TestSCPBase;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestHBCKSCP
extends TestSCPBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestHBCKSCP.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBCKSCP.class);
    @Rule
    public TestName name = new TestName();

    @Test
    public void test() throws Exception {
        int count;
        MiniHBaseCluster cluster = this.util.getHBaseCluster();
        Assert.assertEquals((long)3L, (long)cluster.getLiveRegionServerThreads().size());
        try (Table table = this.createTable(TableName.valueOf((String)this.name.getMethodName()));){
            this.util.loadTable(table, HBaseTestingUtility.COLUMNS[0]);
            count = this.util.countRows(table);
        }
        Assert.assertTrue((String)"expected some rows", (count > 0 ? 1 : 0) != 0);
        int metaIndex = this.util.getMiniHBaseCluster().getServerWithMeta();
        int rsIndex = (metaIndex + 1) % 3;
        ServerName rsServerName = cluster.getRegionServer(rsIndex).getServerName();
        HMaster master = cluster.getMaster();
        RegionInfo rsRI = (RegionInfo)master.getAssignmentManager().getRegionsOnServer(rsServerName).get(0);
        Result r = MetaTableAccessor.getRegionResult((Connection)master.getConnection(), (byte[])rsRI.getRegionName());
        Assert.assertEquals((Object)RegionState.State.OPEN.toString(), (Object)Bytes.toString((byte[])r.getValue(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER)));
        ServerName serverName = MetaTableAccessor.getServerName((Result)r, (int)0);
        Assert.assertEquals((Object)rsServerName, (Object)serverName);
        LOG.info("Killing {}", (Object)rsServerName);
        cluster.killRegionServer(rsServerName);
        master.getServerManager().moveFromOnlineToDeadServers(rsServerName);
        master.getServerManager().getDeadServers().finish(rsServerName);
        master.getServerManager().getDeadServers().removeDeadServer(rsServerName);
        master.getAssignmentManager().getRegionStates().removeServer(rsServerName);
        HRegionServer hrs = cluster.getRegionServer(rsServerName);
        while (!hrs.isStopped()) {
            Threads.sleep((long)10L);
        }
        LOG.info("Dead {}", (Object)rsServerName);
        Assert.assertTrue((boolean)this.searchMeta(master, rsServerName));
        r = MetaTableAccessor.getRegionResult((Connection)master.getConnection(), (byte[])rsRI.getRegionName());
        Assert.assertEquals((Object)RegionState.State.OPEN.toString(), (Object)Bytes.toString((byte[])r.getValue(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER)));
        serverName = MetaTableAccessor.getServerName((Result)r, (int)0);
        TestCase.assertNotNull((Object)cluster.getRegionServer(serverName));
        Assert.assertEquals((Object)rsServerName, (Object)serverName);
        long pid = this.scheduleHBCKSCP(rsServerName, master);
        Assert.assertNotEquals((long)-1L, (long)pid);
        while (master.getMasterProcedureExecutor().getActiveProcIds().contains(pid)) {
            Threads.sleep((long)10L);
        }
        r = MetaTableAccessor.getRegionResult((Connection)master.getConnection(), (byte[])rsRI.getRegionName());
        Assert.assertEquals((Object)RegionState.State.OPEN.toString(), (Object)Bytes.toString((byte[])r.getValue(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER)));
        serverName = MetaTableAccessor.getServerName((Result)r, (int)0);
        TestCase.assertNotNull((Object)cluster.getRegionServer(serverName));
        Assert.assertNotEquals((Object)rsServerName, (Object)serverName);
        TestCase.assertFalse((boolean)this.searchMeta(master, rsServerName));
    }

    protected long scheduleHBCKSCP(ServerName rsServerName, HMaster master) throws ServiceException {
        MasterProtos.ScheduleServerCrashProcedureResponse response = master.getMasterRpcServices().scheduleServerCrashProcedure(null, MasterProtos.ScheduleServerCrashProcedureRequest.newBuilder().addServerName(ProtobufUtil.toServerName((ServerName)rsServerName)).build());
        Assert.assertEquals((long)1L, (long)response.getPidCount());
        long pid = response.getPid(0);
        return pid;
    }

    private boolean searchMeta(HMaster master, ServerName sn) throws IOException {
        List ps = MetaTableAccessor.getTableRegionsAndLocations((Connection)master.getConnection(), null);
        for (Pair p : ps) {
            if (!((ServerName)p.getSecond()).equals((Object)sn)) continue;
            return true;
        }
        return false;
    }
}

