/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentTestingUtil;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.procedure.TestSCPBase;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestSCP
extends TestSCPBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSCP.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSCP.class);

    @Test
    public void testCrashTargetRs() throws Exception {
        this.testRecoveryAndDoubleExecution(false, false);
    }

    @Test
    public void testConcurrentSCPForSameServer() throws Exception {
        TableName tableName = TableName.valueOf((String)"testConcurrentSCPForSameServer");
        try (Table t = this.createTable(tableName);){
            this.util.loadTable(t, HBaseTestingUtility.COLUMNS[0]);
            int count = this.util.countRows(t);
            Assert.assertTrue((String)"expected some rows", (count > 0 ? 1 : 0) != 0);
            ServerName rsToKill = null;
            for (RegionInfo hri : this.util.getAdmin().getRegions(tableName)) {
                ServerName serverName = AssignmentTestingUtil.getServerHoldingRegion(this.util, hri);
                if (!AssignmentTestingUtil.isServerHoldingMeta(this.util, serverName)) continue;
                rsToKill = serverName;
                break;
            }
            HMaster master = this.util.getHBaseCluster().getMaster();
            ProcedureExecutor pExecutor = master.getMasterProcedureExecutor();
            ServerCrashProcedure procB = new ServerCrashProcedure((MasterProcedureEnv)pExecutor.getEnvironment(), rsToKill, false, false);
            AssignmentTestingUtil.killRs(this.util, rsToKill);
            long procId = this.getSCPProcId(pExecutor);
            Procedure procA = pExecutor.getProcedure(procId);
            LOG.info("submit SCP procedureA");
            this.util.waitFor(5000L, () -> procA.hasLock());
            LOG.info("procedureA acquired the lock");
            Assert.assertEquals((Object)Procedure.LockState.LOCK_EVENT_WAIT, (Object)procB.acquireLock((MasterProcedureEnv)pExecutor.getEnvironment()));
            LOG.info("procedureB should not be able to get the lock");
            this.util.waitFor(60000L, () -> procB.acquireLock((MasterProcedureEnv)pExecutor.getEnvironment()) == Procedure.LockState.LOCK_ACQUIRED);
            LOG.info("when procedure B get the lock, procedure A should be finished");
            Assert.assertTrue((boolean)procA.isFinished());
        }
    }
}

