/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.TestAsyncFSWALCorruptionDueToDanglingByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WALCorruptionDueToDanglingByteBufferTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestAsyncFSWALCorruptionDueToDanglingByteBuffer.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    protected static CountDownLatch ARRIVE;
    protected static CountDownLatch RESUME;
    protected static TableName TABLE_NAME;
    protected static byte[] CF;
    protected static byte[] CQ;

    private byte[] getBytes(String prefix, int index) {
        return Bytes.toBytes((String)String.format("%s-%08d", prefix, index));
    }

    @Test
    public void test() throws Exception {
        LOG.info("Stop WAL appending...");
        ARRIVE = new CountDownLatch(1);
        RESUME = new CountDownLatch(1);
        try (Table table = UTIL.getConnection().getTable(TABLE_NAME);){
            int i;
            LOG.info("Put 100 rows with " + Durability.ASYNC_WAL + "...");
            for (i = 0; i < 100; ++i) {
                table.batch(Arrays.asList(new Put(this.getBytes("row", i)).addColumn(CF, CQ, this.getBytes("value", i)).setDurability(Durability.ASYNC_WAL)), new Object[1]);
            }
            ARRIVE.await();
            ARRIVE = null;
            LOG.info("Resume WAL appending...");
            RESUME.countDown();
            LOG.info("Put a single row to force a WAL sync...");
            table.put(new Put(Bytes.toBytes((String)"row")).addColumn(CF, CQ, Bytes.toBytes((String)"value")));
            LOG.info("Abort the only region server");
            UTIL.getMiniHBaseCluster().abortRegionServer(0);
            LOG.info("Start a new region server");
            UTIL.getMiniHBaseCluster().startRegionServerAndWait(30000L);
            UTIL.waitTableAvailable(TABLE_NAME);
            LOG.info("Check if all rows are still valid");
            for (i = 0; i < 100; ++i) {
                Result result = table.get(new Get(this.getBytes("row", i)));
                Assert.assertEquals((Object)Bytes.toString((byte[])this.getBytes("value", i)), (Object)Bytes.toString((byte[])result.getValue(CF, CQ)));
            }
            Result result = table.get(new Get(Bytes.toBytes((String)"row")));
            Assert.assertEquals((Object)"value", (Object)Bytes.toString((byte[])result.getValue(CF, CQ)));
        }
    }

    static {
        TABLE_NAME = TableName.valueOf((String)"Corruption");
        CF = Bytes.toBytes((String)"cf");
        CQ = Bytes.toBytes((String)"cq");
    }
}

