/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.fs;

import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class FileRef
implements Comparable<FileRef> {
    private String metaReference;
    private Path fullReference;
    private Path suffix;

    public FileRef(VolumeManager fs, Key key) {
        this(key.getColumnQualifier().toString(), fs.getFullPath(key));
    }

    public FileRef(String metaReference, Path fullReference) {
        this.metaReference = metaReference;
        this.fullReference = fullReference;
        this.suffix = FileRef.extractSuffix(fullReference);
    }

    public FileRef(String path) {
        this(path, new Path(path));
    }

    public String toString() {
        return this.fullReference.toString();
    }

    public Path path() {
        return this.fullReference;
    }

    public Text meta() {
        return new Text(this.metaReference);
    }

    static Path extractSuffix(Path path) {
        String pstr = path.toString();
        int index = pstr.lastIndexOf(VolumeManager.FileType.TABLE.getDirectory());
        if (index < 0) {
            throw new IllegalArgumentException("Invalid table path " + pstr);
        }
        try {
            Path parent = path.getParent().getParent();
            if (!parent.getName().equals(VolumeManager.FileType.TABLE.getDirectory()) && !parent.getParent().getName().equals(VolumeManager.FileType.TABLE.getDirectory())) {
                throw new IllegalArgumentException("Invalid table path " + pstr);
            }
        }
        catch (NullPointerException npe) {
            throw new IllegalArgumentException("Invalid table path " + pstr);
        }
        return new Path(pstr.substring(index + VolumeManager.FileType.TABLE.getDirectory().length() + 1));
    }

    @Override
    public int compareTo(FileRef o) {
        return this.suffix.compareTo((Object)o.suffix);
    }

    public int hashCode() {
        return this.suffix.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileRef) {
            return this.compareTo((FileRef)obj) == 0;
        }
        return false;
    }
}

